<?php
/**
 * Holds import/export functionality related images.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

namespace BuddyBossApp\Admin\Tools\ImportExport;

use BuddyBossApp\Admin\Tools\ImportExport;
use BuddyBossApp\Helpers\BBAPP_File;

/**
 * Import/Export class for images.
 */
class Images {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Import/Export module name.
	 *
	 * @var $module_name
	 */
	private $module_name;

	/**
	 * Get the instance of the class.
	 *
	 * @return Images
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Branding constructor.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Load method.
	 */
	public function load() {
		$this->module_name = 'images';

		// Register The Module.
		ImportExport::instance()->module_register( $this->module_name, __( 'Images', 'buddyboss-app' ) );

		// Register the hooks for import and export data.
		ImportExport::instance()->hook_register(
			$this->module_name,
			array( $this, 'import' ),
			array( $this, 'export' )
		);
	}

	/**
	 * Import data function.
	 *
	 * @param array $data Import data.
	 *
	 * @return array
	 */
	public function import( $data ) {

		if ( isset( $data['data']['branding'] ) ) {

			if ( ! is_array( $data['data']['branding'] ) ) {
				$data['data']['branding'] = array();
			}

			\BuddyBossApp\Branding::instance()->set_options( $data['data']['branding'] );
		}

		$branding_dir = \BuddyBossApp\Branding::instance()->get_branding_upload_dir();

		// Copy the branding files.

		// Clear fonts directory first.
		BBAPP_File::delete_dir( $branding_dir );
		BBAPP_File::create_dir( $branding_dir );

		foreach ( $data['assets'] as $file_name => $file_path ) {
			$copy_to_file_path = trailingslashit( $branding_dir ) . $file_name;
			BBAPP_File::copy_file( $file_path, $copy_to_file_path );
		}

		return $data;
	}

	/**
	 * Export data function.
	 *
	 * @param array $data Export data.
	 *
	 * @return array
	 */
	public function export( $data ) {

		$branding_settings        = \BuddyBossApp\Branding::instance()->get_options();
		$data['data']['branding'] = $branding_settings;
		$branding_dir             = \BuddyBossApp\Branding::instance()->get_branding_upload_dir();
		// Export Files.
		$objects = scandir( $branding_dir );

		foreach ( $objects as $object ) {
			if ( '.' !== $object && '..' !== $object ) {
				$data['assets'][ $object ] = trailingslashit( $branding_dir ) . "/$object";
			}
		}

		return $data;
	}
}
