<?php
/**
 * Import/Export class for custom icons.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

namespace BuddyBossApp\Admin\Tools\ImportExport;

use BuddyBossApp\Admin\Tools\ImportExport;
use BuddyBossApp\Helpers\BBAPP_File;

/**
 * Custom icons class for import/export.
 */
class CustomIcons {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Import/Export module name.
	 *
	 * @var $module_name
	 */
	private $module_name;

	/**
	 * Get the instance of the class.
	 *
	 * @return CustomIcons
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Construct method.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Load function.
	 */
	public function load() {
		$this->module_name = 'customicons';

		// Register The Module.
		ImportExport::instance()->module_register( $this->module_name, __( 'Custom Icons', 'buddyboss-app' ) );

		// Register the hooks for import and export data.
		ImportExport::instance()->hook_register(
			$this->module_name,
			array( $this, 'import' ),
			array( $this, 'export' )
		);
	}

	/**
	 * Import data function.
	 *
	 * @param array $data Import data.
	 *
	 * @return array
	 */
	public function import( $data ) {

		$custom_icon_dir = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_dir();

		// Clear fonts directory first.
		BBAPP_File::delete_dir( $custom_icon_dir );
		BBAPP_File::create_dir( $custom_icon_dir );

		// Copy the files.
		foreach ( $data['assets'] as $file_name => $file_path ) {
			$copy_to_file_path = trailingslashit( $custom_icon_dir ) . $file_name;
			BBAPP_File::copy_file( $file_path, $copy_to_file_path );
		}

		return $data;
	}

	/**
	 * Export data function.
	 *
	 * @param array $data Export data.
	 *
	 * @return array
	 */
	public function export( $data ) {

		$data['assets'] = array();

		$custom_icons = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_list();

		$custom_icon_dir = \BuddyBossApp\Common\IconPicker::instance()->icon_picker_custom_icon_dir();

		foreach ( $custom_icons as $icon ) {
			$file_name = str_replace( 'custom/', '', $icon );
			$icon_path = trailingslashit( $custom_icon_dir ) . $file_name;
			if ( file_exists( $icon_path ) ) {
				$data['assets'][ $file_name ] = $icon_path;
			}
		}

		return $data;
	}



}
