<?php
/**
 * Holds import/export functionality for branding color.
 *
 * @package BuddyBossApp\Admin\Tools\ImportExport
 */

namespace BuddyBossApp\Admin\Tools\ImportExport;

use BuddyBossApp\Admin\Tools\ImportExport;

/**
 * Import/Export class for color.
 */
class Colors {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Import/Export module name.
	 *
	 * @var $module_name
	 */
	private $module_name;

	/**
	 * Get the instance of the class.
	 *
	 * @return Colors
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Construct method.
	 */
	public function __construct() {
		// Using Singleton, see instance().
	}

	/**
	 * Load method.
	 */
	public function load() {
		$this->module_name = 'colors';

		// Register The Module.
		ImportExport::instance()->module_register( $this->module_name, __( 'Colors', 'buddyboss-app' ) );

		// Register the hooks for import and export data.
		ImportExport::instance()->hook_register(
			$this->module_name,
			array( $this, 'import' ),
			array( $this, 'export' )
		);
	}

	/**
	 * Import data function.
	 *
	 * @param array $data Import data.
	 *
	 * @return array
	 */
	public function import( $data ) {
		if ( isset( $data['data']['styling'] ) && is_array( $data['data']['styling'] ) ) {
			\BuddyBossApp\Styling::instance()->set_options( $data['data']['styling'] );
		}
		return $data;
	}

	/**
	 * Export data function.
	 *
	 * @param array $data Export data.
	 *
	 * @return array
	 */
	public function export( $data ) {
		$styling                 = \BuddyBossApp\Styling::instance()->get_options();
		$data['data']['styling'] = $styling;
		return $data;
	}
}
