<?php
/**
 * Holds PHP version test functionality.
 *
 * @package BuddyBossApp\HealthCheck\Tests
 */

namespace BuddyBossApp\HealthCheck\Tests;

use BuddyBossApp\HealthCheck\TestAbstract;

/**
 * PHP version test.
 */
class PHPVersionTest extends TestAbstract {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * Load method.
	 *
	 * @return mixed|void
	 */
	public function load() {
		$this->register( 'php_tests', __( 'Php Requirements & Recommendations Tests', 'buddyboss-app' ), __( 'These includes all php environments & recommendations tests', 'buddyboss-app' ) );
		$this->add_test(
			'check_php_version',
			__( 'Check PHP Version', 'buddyboss-app' ),
			__( 'Checking Required Min PHP Version', 'buddyboss-app' ),
			array(
				$this,
				'check_php_version_expect',
			),
			'php_tests'
		);
	}

	/**
	 * Function to get the supported PHP version.
	 *
	 * @return array
	 */
	public function check_php_version_expect() {
		$check   = false;
		$message = sprintf(
		/* translators: %s: The current PHP version. */
			__( 'Your site is running the current version of PHP (%s)', 'buddyboss-app' ),
			PHP_VERSION
		);

		if ( version_compare( PHP_VERSION, 7.1, '<=' ) || version_compare( PHP_VERSION, 7.4, '>' ) ) {
			return $this->expect_return( false, __( 'You don\'t have supported php version support. Php version should be between 7.1 to 7.3', 'buddyboss-app' ) );
		} else {
			return $this->expect_return(
				true,
				sprintf(
				/* translators: %s: The current PHP version. */
					__( 'Your site is running with supported PHP version: (%s)', 'buddyboss-app' ),
					PHP_VERSION
				)
			);
		}
	}

}
