<?php
/**
 * Holds cache test functionality.
 *
 * @package BuddyBossApp\HealthCheck\Tests
 */

namespace BuddyBossApp\HealthCheck\Tests;

use BuddyBossApp\HealthCheck\TestAbstract;

/**
 * Clas for cache test.
 */
class CacheTest extends TestAbstract {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * Load method.
	 *
	 * @return mixed|void
	 */
	public function load() {
		$this->register( 'cache_tests', __( 'API Availability Tests', 'buddyboss' ), __( 'Includes all API availability tests.', 'buddyboss' ) );

		$this->add_test(
			'check_cache_activated',
			__( 'Blocked by Caching', 'buddyboss-app' ),
			__( 'Check if the Proxy or Server Level Cache is blocking the App API.', 'buddyboss-app' ),
			array(
				$this,
				'check_cache_activated',
			),
			true
		);
	}

	/**
	 * API Test to check if it's not under any proxy cache or server level cache.
	 *
	 * @return array
	 */
	public function check_cache_activated() {
		$val1 = $this->request_api();
		sleep( 1 );
		$val2 = $this->request_api();

		if ( $val1 === $val2 ) {
			return $this->expect_return( false, __( 'API requests are being interrupted by some external cache. This can make your app work slower and some of the app features may not work properly.', 'buddyboss-app' ) );
		} else {
			return $this->expect_return( true, __( 'All good API is accessible without any interruption.', 'buddyboss-app' ) );
		}
	}

	/**
	 * Function check request API.
	 *
	 * @return false
	 */
	private function request_api() {
		$response = wp_remote_get( rest_url( 'buddyboss-app/core/v1/cache_test' ) );
		if ( is_wp_error( $response ) ) {
			return false;
		}

		$body = wp_remote_retrieve_body( $response );
		$data = json_decode( $body );
		return isset( $data->timestamp ) ? $data->timestamp : false;
	}

}
