<?php
/**
 * Holds Ab Core test functionality.
 *
 * @package BuddyBossApp\HealthCheck\Tests
 */

namespace BuddyBossApp\HealthCheck\Tests;

/**
 * Class for ABCoreTest.
 */
class ABCoreTest extends RestTest {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * Load method.
	 *
	 * @return mixed|void
	 */
	public function load() {
		/*Temporary hide */
		$this->register( 'bbapp_core_tests', __( 'BuddyBoss App API Tests', 'buddyboss-app' ), __( 'Includes all functional tests of base API\'s requires by BuddyBoss App.', 'buddyboss-app' ) );

		$this->add_test(
			'auth_endpoint',
			__( 'Authentication Endpoint.', 'buddyboss-app' ),
			__( 'Checking Authentication endpoints', 'buddyboss-app' ),
			array(
				$this,
				'check_auth_endpoint',
			),
			true
		);

		$this->add_test(
			'app_menu_endpoint',
			__( 'App Menu Endpoint.', 'buddyboss-app' ),
			__( 'Checking App menu endpoints', 'buddyboss-app' ),
			array(
				$this,
				'check_app_menu_endpoint',
			),
			true
		);
	}

	/**
	 * API Test to check Authentication endpoints is valid or not.'
	 *
	 * @return array
	 */
	public function check_auth_endpoint() {
		$test_user = $this->get_test_user();
		if ( empty( $test_user ) ) {
			$this->expect_return( false, __( 'Test user not found', 'buddyboss-app' ) );
		}

		$response = $this->post(
			rest_url( 'buddyboss-app/auth/v1/jwt/token' ),
			array(
				'username'    => $test_user['username'],
				'password'    => $test_user['password'],
				'unique_id'   => $this->get_app_id(),
				'deviceToken' => '123',
			),
			false
		);

		$errors = array();

		/**
		 * Check endpoint assets
		 */
		$errors['status']       = $this->expect_status( $response, 200 );
		$errors['content_type'] = $this->expect_content_type( $response, 'application/json' );

		$data               = json_decode( $response['body'], true );
		$errors['property'] = $this->expect_property(
			$data,
			array(
				'token' => '',
			)
		);

		if ( is_array( $errors['property'] ) && true === $errors['property']['status'] ) {
			$this->setup_test_user_token( $response['body'] );
		}

		return $this->combine_error( $errors, __( 'Authentication endpoint working fine!', 'buddyboss-app' ) );
	}

	/**
	 * API Test to check if it's not under any proxy ABCoreTest or server level cache.
	 *
	 * @return array
	 */
	public function check_app_menu_endpoint() {
		$endpoint = 'buddyboss-app/core/v1/menu/';
		$response = $this->get( rest_url( $endpoint ) );

		$errors = array();

		/**
		 * Check endpoint assets
		 */
		$errors['status']       = $this->expect_status( $response, 200 );
		$errors['content_type'] = $this->expect_content_type( $response, 'application/json' );
		$errors['header']       = $this->expect_header(
			$response,
			array(
				'bbapp-logged-in' => 'yes',
			)
		);

		$data               = json_decode( $response['body'], true );
		$errors['property'] = $this->expect_property(
			$data[0],
			array(
				'label' => '',
				'name'  => '',
			)
		);

		return $this->combine_error( $errors, __( 'App menu endpoint working fine!', 'buddyboss-app' ) );
	}

}
