<?php
/**
 * Load all tools module.
 *
 * @package BuddyBossApp\Admin
 */

namespace BuddyBossApp\Admin;

use BuddyBossApp\Admin\Tools\HealthCheck;
use BuddyBossApp\Admin\Tools\ImportExport;

/**
 * Tools class.
 */
class Tools {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Tools
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Tools constructor.
	 */
	public function __construct() {
	}

	/**
	 * Tools load method.
	 *
	 * @return void
	 */
	public function load() {
		// Import Export.
		ImportExport::instance();
		// Health Check.
		HealthCheck::instance();
	}

}
