<?php
/**
 * Holds IOS publish helping functionality.
 *
 * @package BuddyBossApp\Admin\Publish
 */

namespace BuddyBossApp\Admin\Publish;

/**
 * IOS helper class.
 */
class iOSHelper { // phpcs:ignore PEAR.NamingConventions.ValidClassName.StartWithCapital, Generic.Classes.OpeningBraceSameLine.ContentAfterBrace

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return iOSHelper
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * IOSHelper constructor.
	 */
	public function __construct() {
	}

	/**
	 * Filters/hooks here.
	 */
	public function load() {
	}

	/**
	 * Function to get value from the array.
	 *
	 * @param array      $array   Array to get value.
	 * @param int|string $key     Key to get value.
	 * @param string     $default Default value to send.
	 *
	 * @return string
	 */
	public function get_array_value( $array, $key, $default = '' ) {
		if ( isset( $array[ $key ] ) ) {
			return $array[ $key ];
		} else {
			return $default;
		}
	}

	/**
	 * Returns the review information related to iOS.
	 *
	 * @param string $env Environment platform.
	 *
	 * @return array
	 */
	public function get_review_information( $env ) {
		$review_info   = array();
		$settings      = \BuddyBossApp\ManageApp::instance()->get_app_settings( true );
		$ios_edit_link = bbapp_get_admin_url( 'admin.php?page=bbapp-publish&setting=ios' );

		$value                          = $this->get_array_value( $settings, 'publish.ios.api_private_key', '' );
		$review_info['api_private_key'] = array(
			'label'     => __( 'Private Key', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( ! empty( $value ) ),
			'edit_link' => $ios_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.ios.api_issuer_id', '' );
		$review_info['api_issuer_id'] = array(
			'label'     => __( 'Issuer ID', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( ! empty( $value ) ),
			'edit_link' => $ios_edit_link,
		);

		$value                     = $this->get_array_value( $settings, 'publish.ios.api_key_id', '' );
		$review_info['api_key_id'] = array(
			'label'     => __( 'Key ID', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( ! empty( $value ) ),
			'edit_link' => $ios_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.ios.ios_platforms', '' );
		$review_info['ios_platforms'] = array(
			'label'     => __( 'Platforms', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                   = $this->get_array_value( $settings, 'publish.ios.app_name', '' );
		$review_info['app_name'] = array(
			'label'     => __( 'Name', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                   = $this->get_array_value( $settings, 'publish.ios.app_lang', '' );
		$review_info['app_lang'] = array(
			'label'     => __( 'Primary Language', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                    = $this->get_array_value( $settings, 'publish.ios.bundle_id', '' );
		$review_info['bundle_id'] = array(
			'label'     => __( 'Bundle ID', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value              = $this->get_array_value( $settings, 'publish.ios.sku', '' );
		$review_info['sku'] = array(
			'label'     => __( 'SKU', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                       = $this->get_array_value( $settings, 'publish.ios.ios_app_name', '' );
		$review_info['ios_app_name'] = array(
			'label'     => __( 'Name', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                                 = $this->get_array_value( $settings, 'publish.ios.app_privacy_policy_url', '' );
		$review_info['app_privacy_policy_url'] = array(
			'label'     => __( 'Privacy Policy URL', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                           = $this->get_array_value( $settings, 'publish.ios.ios_app_subtitle', '' );
		$review_info['ios_app_subtitle'] = array(
			'label'     => __( 'Subtitle', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                            = $this->get_array_value( $settings, 'publish.ios.ios_app_bundle_id', '' );
		$review_info['ios_app_bundle_id'] = array(
			'label'     => __( 'Bundle ID', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                               = $this->get_array_value( $settings, 'publish.ios.ios_primary_category', '' );
		$review_info['ios_primary_category'] = array(
			'label'     => __( 'Category / Primary', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                                 = $this->get_array_value( $settings, 'publish.ios.ios_secondary_category', '' );
		$review_info['ios_secondary_category'] = array(
			'label'     => __( 'Category / Secondary', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                           = $this->get_array_value( $settings, 'publish.ios.ios_appmeta_info', '' );
		$review_info['ios_appmeta_info'] = array(
			'label'     => __( 'App Meta Info', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                          = $this->get_array_value( $settings, 'publish.ios.ios_promotional', '' );
		$review_info['ios_promotional'] = array(
			'label'     => __( 'Promotional Text', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                       = $this->get_array_value( $settings, 'publish.ios.ios_keywords', '' );
		$review_info['ios_keywords'] = array(
			'label'     => __( 'Keywords ', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                          = $this->get_array_value( $settings, 'publish.ios.ios_description', '' );
		$review_info['ios_description'] = array(
			'label'     => __( 'Description ', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                          = $this->get_array_value( $settings, 'publish.ios.ios_support_url', '' );
		$review_info['ios_support_url'] = array(
			'label'     => __( 'Support URL ', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                          = $this->get_array_value( $settings, 'publish.ios.ios_territories', '' );
		$review_info['ios_territories'] = array(
			'label'     => __( 'Territories ', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                    = $this->get_array_value( $settings, 'publish.ios.ios_price', '' );
		$review_info['ios_price'] = array(
			'label'     => __( 'Price ', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                                       = $this->get_array_value( $settings, 'publish.ios.ios_app_multiple_screenshots', '' );
		$review_info['ios_app_multiple_screenshots'] = array(
			'label'          => __( 'Screenshots', 'buddyboss-app' ),
			'value'          => $value,
			'validated'      => true,
			'edit_link'      => $ios_edit_link,
			'is_multi_image' => true,
		);

		if ( ! empty( $value ) ) {
			foreach ( $value as $val ) {
				$review_info['files'][ wp_get_attachment_url( $val ) ] = get_attached_file( $val ); // Full path.
			}
		}

		$value                      = $this->get_array_value( $settings, 'publish.ios.ios_display', '' );
		$review_info['ios_display'] = array(
			'label'     => __( 'Display Type ', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                              = $this->get_array_value( $settings, 'publish.ios.ios_app_screenshots', '' );
		$value_path                         = ( ! empty( $_SERVER['DOCUMENT_ROOT'] ) ) ? $_SERVER['DOCUMENT_ROOT'] . wp_make_link_relative( $value ) : ''; //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.MissingUnslash
		$review_info['ios_app_screenshots'] = array(
			'label'     => __( 'App Screenshot', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$review_info['files'][ $value ]    = $value_path;
		$value                             = $this->get_array_value( $settings, 'publish.ios.ios_price_build_id', '' );
		$review_info['ios_price_build_id'] = array(
			'label'     => __( 'Build ID', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.ios.ios_changelog', '' );
		$review_info['ios_changelog'] = array(
			'label'     => __( 'Changelog', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $ios_edit_link,
		);

		return $review_info;
	}
}
