<?php
/**
 * Holds Android publish helper functions.
 *
 * @package BuddyBossApp\Admin\Publish
 */

namespace BuddyBossApp\Admin\Publish;

use BuddyBossApp\Admin\Appearance\Branding;
use BuddyBossApp\ManageApp;

/**
 * Publish android helper class.
 */
class AndroidHelper {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return AndroidHelper
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * AndroidHelper constructor.
	 */
	public function __construct() {
	}

	/**
	 * Filters/hooks here.
	 */
	public function load() {
	}

	/**
	 * Function to get value from the array.
	 *
	 * @param array      $array   Array to get value.
	 * @param int|string $key     Key to get value.
	 * @param string     $default Default value to send.
	 *
	 * @return string
	 */
	public function get_array_value( $array, $key, $default = '' ) {
		if ( isset( $array[ $key ] ) ) {
			return $array[ $key ];
		} else {
			return $default;
		}
	}

	/**
	 * Returns the review information related to Android
	 *
	 * @param string $env Platform environment.
	 *
	 * @return array
	 */
	public function get_review_information( $env ) {
		$settings    = ManageApp::instance()->get_app_settings();
		$review_info = array();

		$value                   = $this->get_array_value( $settings, 'publish.android.app_name', '' );
		$androidos_edit_link     = bbapp_get_admin_url( 'admin.php?page=bbapp-publish&setting=android' );
		$review_info['app_name'] = array(
			'label'     => __( 'App Name', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( ! empty( $value ) ),
			'edit_link' => $androidos_edit_link,
		);

		$value                   = $this->get_array_value( $settings, 'publish.android.app_lang', '' );
		$review_info['app_lang'] = array(
			'label'     => __( 'App Language', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( ! empty( $value ) ),
			'edit_link' => $androidos_edit_link,
		);

		$value                         = $this->get_array_value( $settings, 'publish.android.app_short_desc', '' );
		$review_info['app_short_desc'] = array(
			'label'     => __( 'Short description', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( ! empty( $value ) ),
			'edit_link' => $androidos_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.android.app_full_desc', '' );
		$review_info['app_full_desc'] = array(
			'label'     => __( 'Full description', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                          = $this->get_array_value( $settings, 'publish.android.app_screenshots', '' );
		$review_info['app_screenshots'] = array(
			'label'          => __( 'screenshots', 'buddyboss-app' ),
			'value'          => $value,
			'validated'      => true,
			'edit_link'      => $androidos_edit_link,
			'is_multi_image' => true,
		);

		if ( ! empty( $value ) ) {
			foreach ( $value as $val ) {
				$review_info['files'][ wp_get_attachment_url( $val ) ] = get_attached_file( $val ); // Full path.
			}
		}

		$value                        = $this->get_array_value( $settings, 'publish.android.app_promo_url', '' );
		$review_info['app_promo_url'] = array(
			'label'     => __( 'Promo Video URL', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                   = $this->get_array_value( $settings, 'publish.android.app_type', '' );
		$review_info['app_type'] = array(
			'label'     => __( 'App Type', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                       = $this->get_array_value( $settings, 'publish.android.app_category', '' );
		$review_info['app_category'] = array(
			'label'     => __( 'Category', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                             = $this->get_array_value( $settings, 'publish.android.app_content_rating', '' );
		$review_info['app_content_rating'] = array(
			'label'     => __( 'Content Rating', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                  = $this->get_array_value( $settings, 'publish.android.app_web', '' );
		$review_info['app_web'] = array(
			'label'     => __( 'Web', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                    = $this->get_array_value( $settings, 'publish.android.app_email', '' );
		$review_info['app_email'] = array(
			'label'     => __( 'Email', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                                 = $this->get_array_value( $settings, 'publish.android.app_privacy_policy_url', '' );
		$review_info['app_privacy_policy_url'] = array(
			'label'     => __( 'Privacy Policy URL', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                  = $this->get_array_value( $settings, 'publish.android.app_apk', '' );
		$review_info['app_apk'] = array(
			'label'     => __( 'APK (build)', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                    = $this->get_array_value( $settings, 'publish.android.app_price', '' );
		$review_info['app_price'] = array(
			'label'     => __( 'Paid/Free', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.android.app_countries', '' );
		$review_info['app_countries'] = array(
			'label'     => __( 'Countries', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.android.app_education', '' );
		$review_info['app_education'] = array(
			'label'     => __( 'For education', 'buddyboss-app' ),
			'value'     => ( $value ) ? __( 'Yes', 'buddyboss-app' ) : __( 'No', 'buddyboss-app' ),
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                               = $this->get_array_value( $settings, 'publish.android.app_marketing_optout', '' );
		$review_info['app_marketing_optout'] = array(
			'label'     => __( 'Marketing Opt-Out', 'buddyboss-app' ),
			'value'     => ( $value ) ? __( 'Yes', 'buddyboss-app' ) : __( 'No', 'buddyboss-app' ),
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                                 = $this->get_array_value( $settings, 'publish.android.app_content_guidelines', '' );
		$review_info['app_content_guidelines'] = array(
			'label'     => __( 'Content Guidelines', 'buddyboss-app' ),
			'value'     => ( $value ) ? __( 'Yes', 'buddyboss-app' ) : __( 'No', 'buddyboss-app' ),
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                             = $this->get_array_value( $settings, 'publish.android.app_us_export_laws', '' );
		$review_info['app_us_export_laws'] = array(
			'label'     => __( 'US Export Laws', 'buddyboss-app' ),
			'value'     => ( $value ) ? __( 'Yes', 'buddyboss-app' ) : __( 'No', 'buddyboss-app' ),
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$value                        = $this->get_array_value( $settings, 'publish.android.app_changelog', '' );
		$review_info['app_changelog'] = array(
			'label'     => __( 'Changelog', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => true,
			'edit_link' => $androidos_edit_link,
		);

		$upload_dir                          = wp_upload_dir();
		$value                               = $upload_dir['baseurl'] . $this->get_array_value( $settings, 'publish.android.google_services_json', '' );
		$value_path                          = $upload_dir['basedir'] . $this->get_array_value( $settings, 'publish.android.google_services_json', '' );
		$review_info['google_services_json'] = array(
			'label'     => __( 'Google Play: Authorize JSON Key File', 'buddyboss-app' ),
			'value'     => $value,
			'validated' => ( is_file( $value_path ) ),
			'edit_link' => $androidos_edit_link . '#bbapp_firebase_settings',
		);
		$review_info['files'][ $value ]      = $value_path;

		return $review_info;
	}
}
