<?php
/**
 * Holds beta features functionality.
 *
 * @package BuddyBossApp\Admin
 */

namespace BuddyBossApp\Admin;

use BuddyBossApp\ManageApp;

/**
 * Labs class.
 */
class Labs {

	/**
	 * Class instance.
	 *
	 * @since 1.5.2.1
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Form variable.
	 *
	 * @since 1.5.2.1
	 *
	 * @var $settings_form
	 */
	private $settings_form;

	/**
	 * Get the instance of the class.
	 *
	 * @since 1.5.2.1
	 *
	 * @return Labs
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * Render Setting Form.
	 *
	 * @since 1.5.2.1
	 */
	public function render_settings() {
		$this->settings_form->render_form();
	}

	/**
	 * Load Settings.
	 *
	 * @since 1.5.2.1
	 */
	public function load_settings() {
		$this->settings_form = new FormProvider( 'settings' );
		// holds app settings storage handle.
		$app_settings_provider     = new SettingProvider( 'app_settings' );

		// Register app settings storing & receiving.
		$app_settings_provider->save_setting_hook( array( $this, 'save_settings' ) );
		$app_settings_provider->get_setting_hook( array( $this, 'get_settings' ) );

		// Link Provider In Form Provider.
		$this->settings_form->link_setting_provider( $app_settings_provider );

		add_action( 'admin_init', array( $this->settings_form, 'save' ) );

		$this->settings_form->add_field(
			$app_settings_provider->field(
				false,
				array(
					'type'    => 'table-open',
					'classes' => 'buddyboss-app-admin-card bbapp-admin-lab',
				)
			)
		);

		$this->settings_form->add_field(
			$app_settings_provider->field(
				'app_lab_heading',
				array(
					'type'  => 'heading',
					'value' => __( 'BuddyBoss Labs', 'buddyboss-app' ),
					'desc'  => __( '<span class="description">BuddyBoss Labs provides early-access to upcoming BuddyBoss features. You can help us prepare these features for release by reporting issues and providing feedback through the <a href="https://www.buddyboss.com/contact/" target="_blank">support portal</a>.</span><br><br><span class="description">Please note, customer support will not be able to provide support for these features until their official release.</span>', 'buddyboss-app' ),
					'icon'  => 'bb-icon-bf bb-icon-flask',
				)
			)
		);
	}

	/**
	 * Saves the settings which are app id specific.
	 *
	 * @param array $settings Settings.
	 *
	 * @since 1.5.2.1
	 *
	 * @return bool
	 */
	public function save_settings( $settings ) {
		ManageApp::instance()->update_app_settings( $settings );

		return true;
	}

	/**
	 * Gets the settings which are app id specific.
	 *
	 * @since 1.5.2.1
	 */
	public function get_settings() {
		$settings = ManageApp::instance()->get_app_settings();

		return $settings;
	}
}
