<?php
/**
 * Holds help articles functionality.
 *
 * @package BuddyBossApp\Admin
 */

namespace BuddyBossApp\Admin;

/**
 * Help class.
 */
class Help {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Help
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Help constructor.
	 */
	public function __construct() {
	}

	/**
	 * Filters/hooks here.
	 */
	public function load() {
	}

	/**
	 * Return the sub settings.
	 *
	 * @return array
	 */
	public function sub_settings() {
		return array(
			'help' => __( 'Help', 'buddyboss-app' ),
		);
	}

	/**
	 * Declares which sub settings will be hidden.
	 *
	 * @return array
	 */
	public function hidden_sub_settings() {
		return array();
	}

	/**
	 * Return the current setting page from active screen.
	 *
	 * @return string
	 */
	public function get_current_sub_tab() {
		$default      = 'help';
		$setting      = ( isset( $_GET['setting'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : $default; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$sub_settings = $this->sub_settings();

		if ( isset( $sub_settings[ $setting ] ) ) {
			return $setting;
		}

		return $default;
	}

	/**
	 * Renders the setting screen.
	 */
	public function render_screen() {
		\BuddyBossApp\Admin\SetupAdmin::instance()->render_subtabs( $this->sub_settings(), $this->get_current_sub_tab() );
		?>
		<div class="wrap">
			<h1>
				<?php esc_html_e( 'Documentation', 'buddyboss-app' ); ?>
				<a href="https://www.buddyboss.com/resources/docs/" class="page-title-action" target="_blank">
					<?php esc_html_e( 'Resources Website', 'buddyboss-app' ); ?>
				</a>
			</h1>

			<div class="wp-list-table widefat bbapp-help-card-grid">
				<?php
				$this->admin_help_main_page();
				?>
			</div>
		</div>
		<script>
			jQuery ( document ).ready ( function () {
				bbappCore.help.start ();
			} );
		</script>
		<?php
	}

	/**
	 * Show the main index page of HELP page
	 *
	 * @since BuddyBossApp 3.0.0
	 */
	public function admin_help_main_page() {
		?>
		<div class="bbapp-help-main-menu-wrap" id="bbapp-help-main-menu-wrap" style="display:none">
		</div>
		<div class="bbapp-help-content-wrap" style="display:none">
			<div class="bbapp-help-sidebar">
			</div>
			<div class="bbapp-help-content">
				<!-- print breadcrumbs -->
				<ul class="bbapp-help-menu">
				</ul>
				<!-- print content -->
				<div id="bbapp-help-content-area"></div>
				<!-- print submenu -->
				<div class="article-child well">
					<h3 id="article-child-title" style="display: none;">
						<?php esc_html_e( 'Articles', 'buddyboss-app' ); ?>
					</h3>
				</div>
			</div>
		</div>
		<?php
	}

	/**
	 * Get the article value from GLOBAL variable
	 *
	 * @return string
	 */
	public function admin_help_get_article_value() {
		return isset( $_REQUEST['article'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['article'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	}

}
