<?php
/**
 * Holds select field functionality.
 *
 * @package BuddyBossApp\Admin\Fields
 */

namespace BuddyBossApp\Admin\Fields;

use BuddyBossApp\Admin\FieldAbstract;

/**
 * Class SelectorSection
 *
 * @package BuddyBossApp\Admin\Fields
 */
class SelectorSection extends FieldAbstract {

	/**
	 * SelectorSection constructor.
	 */
	public function __construct() {
	}

	/**
	 * Selector section get settings.
	 *
	 * @return array
	 */
	public function get_settings() {
		$settings = parent::get_settings();

		if ( ! is_array( $settings ) ) {
			$settings = array();
		}

		return $settings;
	}

	/**
	 * Render selector section html.
	 */
	public function render() {
		$field_name    = $this->get_field_name();
		$value         = $this->get_value();
		$settings      = $this->get_settings();
		$selector_data = isset( $settings['selector_data'] ) && is_callable( $settings['selector_data'] ) ? $settings['selector_data']() : $settings['selector_data'];
		$sections      = $selector_data['sections'];
		$selector_data['selector_data']['left']['pager']  = $sections['left']['pager'];
		$selector_data['selector_data']['right']['pager'] = $sections['right']['pager'];
		$element_data                                     = $selector_data['selector_data'];

		?>
		<?php if ( isset( $settings['desc'] ) && ! empty( $settings['desc'] ) ) : ?>
			<p class="description bbapp-admin-description">
				<?php echo wp_kses_post( $settings['desc'] ); ?>
			</p>
		<?php endif; ?>
		<div id="<?php echo esc_attr( $settings['html_id'] ); ?>" data-nonce="<?php echo esc_attr( wp_create_nonce( 'bbapp-selector-' . get_current_user_id() ) ); ?>" data-action="<?php echo esc_attr( $element_data['selector_action'] ); ?>" class="<?php echo esc_attr( $settings['html_id'] ); ?> bbapp-selector" data="<?php echo esc_html( htmlspecialchars( wp_json_encode( $element_data ) ) ); ?>">
			<input type="hidden" class="bbapp-selector-form-element" name="<?php echo esc_attr( $field_name ); ?>" value="<?php echo esc_html( htmlspecialchars( wp_json_encode( $value, JSON_FORCE_OBJECT ) ) ); ?>"/>
			<input type="hidden" class="bbapp-selector-form-remove-element" name="<?php echo esc_attr( $settings['remove_element'] ); ?>" value="[]"/>
			<input type="hidden" name="<?php echo esc_attr( $settings['html_id'] ); ?>-nonce" value="<?php echo esc_attr( wp_create_nonce( $settings['html_id'] ) ); ?>"/>
			<input type="hidden" name="<?php echo esc_attr( $settings['html_id'] ); ?>-changed" class="bbapp-selector-form-changed" value=""/>
			<table class="bbapp-selector-table">
				<tr>
					<?php include bbapp()->plugin_dir . 'views/settings/fields/custom-selector-section.php'; ?>
				</tr>
			</table>
		</div>
		<?php
	}

	/**
	 * Filtering the data and everything will go there :).
	 *
	 * @param string $course_ids json encoded course ids.
	 *
	 * @return array|mixed
	 */
	public function save( $course_ids ) {
		// Add hide in app meta.
		if ( isset( $course_ids ) ) {
			$course_ids = (array) json_decode( wp_unslash( $course_ids ) );

			foreach ( $course_ids as $course_id ) {
				update_post_meta( $course_id, '_hide_in_app', 'yes' );
			}
		}

		// Remove element based on right to left.
		if ( isset( $_POST['learndash_bbapp_hide_in_app_remove'] ) ) { //phpcs:ignore WordPress.Security.NonceVerification.Missing
			$learndash_bbapp_hide_in_app_remove = (array) json_decode( wp_unslash( $_POST['learndash_bbapp_hide_in_app_remove'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

			foreach ( $learndash_bbapp_hide_in_app_remove as $course_id ) {
				update_post_meta( $course_id, '_hide_in_app', 'no' );
			}
		}

		return $course_ids;
	}
}
