<?php
/**
 * Holds IOS devices field functionality.
 *
 * @package BuddyBossApp\Admin\Fields
 */

namespace BuddyBossApp\Admin\Fields;

use BuddyBossApp\Admin\FieldAbstract;
use BuddyBossApp\AppStores\Apple;
use BuddyBossApp\Builds\Installer;

/**
 * Class DevicesiOS
 *
 * @package BuddyBossApp\Admin\Fields
 */
class DevicesiOS extends FieldAbstract {

	/**
	 * Upload constructor.
	 */
	public function __construct() {
	}

	/**
	 * Get IOS devices fiedls settings.
	 *
	 * @return array
	 */
	public function get_settings() {
		$settings = parent::get_settings();

		if ( ! is_array( $settings ) ) {
			$settings = array();
		}

		return $settings;
	}

	/**
	 * Render register devices.
	 */
	public function render() {
		global $device_ios_script_loaded;

		echo '<div class="bbapp-upload-field">';

		$field_name = $this->get_field_name();
		$devices    = Apple::instance()->get_local_devices();
		$settings   = $this->get_settings();
		?>
		<div class="bbapp-apple-devices">
			<?php if ( ! Apple::instance()->is_connected() ) : ?>
				<p class="bbapp-notice-box bbapp-notice-box--warning">
					<?php printf( '%1$s <a href="%2$s">%3$s</a> %4$s', esc_html__( 'You need to', 'buddyboss-app' ), esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-configure&setting=ios' ) ), esc_html__( 'connect your Apple Developer account', 'buddyboss-app' ), esc_html__( 'in order to register devices.', 'buddyboss-app' ) ); ?>
				</p>
			<?php else : ?>
				<a href="#" class="button bbapp-apple-add-device-btn button-primary">
					<?php esc_html_e( 'Add New Device', 'buddyboss-app' ); ?>
				</a>
				<a href="#" class="button bbapp-apple-refresh-device-list button-secondary">
					<div class="bbapp_loading" style="display:none;"></div>
					<?php esc_html_e( 'Refresh', 'buddyboss-app' ); ?>
				</a>

				<ul>
					<?php foreach ( $devices as $id => $device ) : ?>
						<li>
							<span class="bbapp-apple-device-name"><strong><?php echo esc_html( $device['name'] ); ?></strong></span>
							<span class="bbapp-apple-device-udid"><?php echo esc_html( $device['udid'] ); ?></span>
						</li>
					<?php endforeach; ?>
				</ul>

				<div class="bbapp-install-device" style="display: none;">
					<div class="overlay"></div>
					<div class="bbapp-dialog">
						<h2 class="no-icon"><?php esc_html_e( 'Add New Device', 'buddyboss-app' ); ?></h2>
						<a href="#" class="close-dialog"></a>
						<div class="device-add-form-wrap">
							<div class="step-1">
								<p>
									<label for="ios-device-name"><?php esc_html_e( 'Device Owner\'s Name', 'buddyboss-app' ); ?></label>
									<input type="text" name="device-name" value="" id="ios-device-name"/>
								</p>
								<p class="button-wrap">
									<button type="button" id="button-next-step" class="button button-primary" name="next-step">
										<div class="bbapp_loading" style="display:none;"></div>
										<?php esc_attr_e( 'Next', 'buddyboss-app' ); ?>
									</button>
								</p>
							</div>
							<div class="step-2 hidden">
								<div class="add-device-information">
									<div class="barcode-wrap">
										<img width="150" src="<?php echo ( \BuddyBossApp\Library\Composer::instance()->qr_code_instance()->qr_code() )->render( Installer::instance()->get_device_register_url() ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>" alt="<?php esc_attr_e( 'QR Code', 'buddyboss-app' ); ?>"/>
									</div>
									<div class="install-instructions">
										<p><?php esc_html_e( 'To automatically register your device, scan this QR code on your iOS device using the camera app.', 'buddyboss-app' ); ?></p>
									</div>
								</div>
								<p><?php esc_html_e( 'Alternatively, you can enter your device\'s UDID manually:', 'buddyboss-app' ); ?></p>

								<p>
									<label for="ios-device-udid"><?php esc_html_e( 'Device UDID', 'buddyboss-app' ); ?></label>
										<input type="text" name="device-udid" value="" id="ios-device-udid" />
									</p>
									<p class="button-wrap">
										<button type="submit" id="add-device-button" class="button button-primary" name="submit" >
											<div class="bbapp_loading" style="display:none;"></div>
											<?php esc_attr_e( 'Add Manually', 'buddyboss-app' ); ?>
										</button>
									</p>

							</div>
						</div>
					</div>
				</div>


				<script type="text/html" id="tmpl-bbapp-apple-device">
					<li>
						<span class="bbapp-apple-device-name"><strong>{{{data.name}}}</strong></span>
						<span class="bbapp-apple-device-udid">{{{data.udid}}}</span>
						<input name="<?php echo esc_attr( "{$field_name}" ); ?>[{{{data.udid}}}]" type='hidden' value="{{{data.name}}}"/>
					</li>
				</script>

			<?php endif; ?>

		</div>

		<?php
		if ( ! isset( $device_ios_script_loaded ) ) :
			$device_ios_script_loaded = true;
			?>
			<script>
				jQuery( document ).ready( function() {
					const template           = wp.template( 'bbapp-apple-device' );
					let deviceRefreshXhr = null;

					jQuery( document ).on( 'click', '.bbapp-apple-add-device-btn', function( e ) {
						e.preventDefault();
						jQuery( '#ios-device-name' ).val( '' );
						jQuery( '#ios-device-udid' ).val( '' );
						jQuery( '.bbapp-install-device' ).show();
					} );

					jQuery( document ).on( 'click', '#button-next-step', function( e ) {
						e.preventDefault();

						const target = jQuery( this );

						if ( target.parents( '.device-add-form-wrap' ).find( '#ios-device-name' ).val() !== '' ) {
							target.find( '.bbapp_loading' ).fadeIn();
							target.addClass( 'loading' );
							jQuery.ajax( {
								url: bbappAjax.ajaxurl,
								type: 'POST',
								data: {
									action: 'update_ios_qr_code',
									device_name: target.parents( '.device-add-form-wrap' ).find( '#ios-device-name' ).val(),
								},
							} ).done( function( response ) {
								if ( response.success && response.data.url ) {
									target.parents( '.device-add-form-wrap' ).find( '.barcode-wrap img' ).attr( 'src', response.data.url );
								}

								target.removeClass( 'loading' );
								target.parents( '.device-add-form-wrap' ).find( '.step-1' ).addClass( 'hidden' );
								target.parents( '.device-add-form-wrap' ).find( '.step-2' ).removeClass( 'hidden' );
								target.find( '.bbapp_loading' ).fadeOut();
							} ).fail( function() {
								target.parents( '.device-add-form-wrap' ).find( '.step-1' ).addClass( 'hidden' );
								target.parents( '.device-add-form-wrap' ).find( '.step-2' ).removeClass( 'hidden' );
								target.removeClass( 'loading' );
								target.find( '.bbapp_loading' ).fadeOut();
							} );
						} else {
							// eslint-disable-next-line no-alert
							alert( '<?php esc_html_e( 'Please add the name of person who owns the device.', 'buddyboss-app' ); ?>' );
						}
					} );

					jQuery( document ).on( 'click', '.bbapp-install-device .close-dialog', function( e ) {
						e.preventDefault();

						const target = jQuery( this );

						target.parents( '.bbapp-dialog' ).find( '.step-1' ).removeClass( 'hidden' );
						target.parents( '.bbapp-dialog' ).find( '.step-2' ).addClass( 'hidden' );
						jQuery( '.bbapp-install-device' ).hide();
					} );

					jQuery( document ).on( 'click', '#add-device-button', function( e ) {
						e.preventDefault();

						const deviceNameField = jQuery( '#add-device-button' ).parents( '.device-add-form-wrap' ).find( '#ios-device-name' );
						const deviceUdidField = jQuery( '#add-device-button' ).parents( '.device-add-form-wrap' ).find( '#ios-device-udid' );
						const deviceName = deviceNameField.val();
						const deviceUdid = deviceUdidField.val();

						if ( deviceName === '' || deviceUdid === '' ) {
							// eslint-disable-next-line no-alert
							alert( "<?php esc_attr_e( 'Device Name or Device UDID cannot be empty.', 'buddyboss-app' ); ?>" );

							return false;
						}

						const regexUdid = /^([A-F0-9]{40}|[A-F0-9]{8}-[A-F0-9]{16})$/gim;

						// Disabling as iPhone 7 vs iPhone XR has diff UDID.
						if ( ! regexUdid.test( deviceUdid ) ) {
							// eslint-disable-next-line no-alert
							alert( "<?php esc_attr_e( 'Provided UDID is not a valid Apple UDID.', 'buddyboss-app' ); ?>" );

							deviceUdidField.val( '' );
							return false;
						}

						const target = jQuery( this );
						jQuery( '#add-device-button' ).prop( 'disabled', true );
						target.find( '.bbapp_loading' ).fadeIn();

						jQuery.ajax( {
							url: bbappAjax.ajaxurl,
							type: 'POST',
							data: {
								action: 'save_ios_devices',
								device_name: deviceName,
								device_udid: deviceUdid,
							},
						} ).done( function( response ) {
							if ( response.success ) {
								jQuery( '.bbapp-apple-devices' ).find( 'ul' ).prepend( template( {
									name: response.data.device_name,
									udid: response.data.device_udid,
								} ) );
								jQuery( '#add-device-button' ).prop( 'disabled', false );
								deviceNameField.val( '' );
								deviceUdidField.val( '' );
								jQuery( '.bbapp-install-device' ).hide();
								target.find( '.bbapp_loading' ).fadeOut();
							} else {
								deviceNameField.val( '' );
								deviceUdidField.val( '' );
								jQuery( '#add-device-button' ).prop( 'disabled', false );
								jQuery( '.bbapp-install-device' ).hide();
								target.find( '.bbapp_loading' ).fadeOut();

								if ( response.message ) {
									// eslint-disable-next-line no-alert
									alert( response.message );
								}
							}

							target.parents( '.device-add-form-wrap' ).find( '.step-1' ).removeClass( 'hidden' );
							target.parents( '.device-add-form-wrap' ).find( '.step-2' ).addClass( 'hidden' );
						} ).fail( function() {
							// eslint-disable-next-line no-alert
							alert( "<?php esc_html_e( 'Network Error. Please try again.', 'buddyboss-app' ); ?>" );

							target.find( '.bbapp_loading' ).fadeOut();
						} );
					} );

					jQuery( document ).on( 'click', '.bbapp-apple-refresh-device-list', function( e ) {
						e.preventDefault();

						jQuery( '.bbapp-apple-refresh-device-list' ).find( '.bbapp_loading' ).fadeIn();

						if ( deviceRefreshXhr ) {
							deviceRefreshXhr.abort();
						}

						deviceRefreshXhr = jQuery.ajax( {
							url: bbappAjax.ajaxurl,
							type: 'POST',
							data: {
								action: 'refresh_ios_devices',
							},
						} ).done( function( response ) {
							if ( response.success && response.data ) {
								jQuery( '.bbapp-apple-devices' ).find( 'ul' ).empty();
								jQuery.each( response.data, function( key, value ) {
									jQuery( '.bbapp-apple-devices' ).find( 'ul' ).prepend( template( {
										name: value.device_name,
										udid: value.device_udid,
									} ) );
								} );
							}

							jQuery( '.bbapp-apple-refresh-device-list' ).find( '.bbapp_loading' ).fadeOut();
						} );
					} );
				} );
			</script>
		<?php endif; ?>
		<br/>
		<?php
	}

	/**
	 * Filtering the data and everything will go there :).
	 *
	 * @param int|string|array $post_value Post value.
	 *
	 * @return mixed
	 * @throws \MingYuanYun\AppStore\Exceptions\ConfigException IOS exception message.
	 */
	public function save( $post_value ) {
		return array(); // no need to save anything on db.
	}
}
