<?php
/**
 * Holds App page field functionality.
 *
 * @package BuddyBossApp\Admin\Fields
 */

namespace BuddyBossApp\Admin\Fields;

use BuddyBossApp\Admin\FieldAbstract;

/**
 * Class AppPage
 *
 * @package BuddyBossApp\Admin\Fields
 */
class AppPage extends FieldAbstract {

	/**
	 * Upload constructor.
	 */
	public function __construct() {
		$this->setting_id = uniqid();
	}

	/**
	 * Get app page field settings.
	 *
	 * @return array
	 */
	public function get_settings() {
		$settings = parent::get_settings();

		if ( ! is_array( $settings ) ) {
			$settings = array();
		}

		return $settings;
	}

	/**
	 * Render App page field.
	 */
	public function render() {
		$app_pages = get_posts(
			array(
				'post_type'   => 'app_page',
				'numberposts' => - 1,
			)
		);

		echo '<div class="bbapp-apppage-field">';

		$field_name = $this->get_field_name();
		$value      = $this->get_value();
		?>
		<select name="<?php echo esc_attr( "{$field_name}" ); ?>">
			<option value=""><?php esc_html_e( '- select app page -', 'buddyboss-app' ); ?></option>
			<?php
			if ( ! empty( $app_pages ) ) {
				foreach ( $app_pages as $app_page ) {
					?>
					<option <?php selected( $value, $app_page->ID ); ?>
							value="<?php echo esc_attr( $app_page->ID ); ?>"><?php echo esc_html( $app_page->post_title ); ?></option>
					<?php
				}
			}
			?>
		</select>
		<?php

		echo '</div>';
	}

	/**
	 * Filtering the data and everything will go there :).
	 *
	 * @param int|string $post_value Post field value.
	 *
	 * @return mixed
	 */
	public function save( $post_value ) {
		return $post_value;
	}
}
