<?php
/**
 * Holds abstract class functionality for field.
 *
 * @package BuddyBossApp\Admin
 */

namespace BuddyBossApp\Admin;

/**
 * Abstract class for fields.
 */
abstract class FieldAbstract {

	/**
	 * Field value.
	 *
	 * @var $value
	 */
	private $value;

	/**
	 * Field settings.
	 *
	 * @var $settings
	 */
	private $settings;

	/**
	 * Field name.
	 *
	 * @var $field_name
	 */
	private $field_name;

	/**
	 * Internal render method for field render.
	 */
	public function field_render() {
		$this->render();
	}

	/**
	 * Abstract method to render field.
	 *
	 * @return mixed
	 */
	abstract public function render();

	/**
	 * Internal save method.
	 *
	 * @param int|string $post_value Field post value.
	 *
	 * @return mixed
	 */
	public function field_save( $post_value ) {
		return $this->save( $post_value );
	}

	/**
	 * Abstract method to save the field value.
	 *
	 * @param int|string $post_value Field post value.
	 *
	 * @return mixed
	 */
	abstract public function save( $post_value );

	/**
	 * Set field value.
	 *
	 * @param int|string $value Field value.
	 */
	public function set_value( $value ) {
		$this->value = $value;
	}

	/**
	 * Get field value.
	 *
	 * @return mixed
	 */
	public function get_value() {
		return $this->value;
	}

	/**
	 * Set field name.
	 *
	 * @param string $name Field name.
	 */
	public function set_field_name( $name ) {
		$this->field_name = $name;
	}

	/**
	 * Get field name.
	 *
	 * @return mixed
	 */
	public function get_field_name() {
		return $this->field_name;
	}

	/**
	 * Set field settings.
	 *
	 * @param array $settings Field settings.
	 */
	public function set_settings( $settings ) {
		$this->settings = $settings;
	}

	/**
	 * Get field settings.
	 *
	 * @return mixed
	 */
	public function get_settings() {
		return $this->settings;
	}
}
