<?php
/**
 * Holds preview functionality of branding section.
 *
 * @package BuddyBossApp\Admin\Appearance
 */

namespace BuddyBossApp\Admin\Appearance;

use BuddyBossApp\Admin\Appearance;

/**
 * Preview class.
 */
class Preview {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Branding
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Branding constructor.
	 */
	public function __construct() {
	}

	/**
	 * Load all method.
	 */
	public function load() {
		add_action( 'wp_ajax_bbapp_get_screen', array( $this, 'bbapp_get_screen' ) );
		add_action( 'wp_ajax_nopriv_bbapp_get_screen', array( $this, 'bbapp_get_screen' ) );
	}

	/**
	 * Get screen.
	 */
	public function bbapp_get_screen() {
		if ( ! is_user_logged_in() ) {
			return '';
		}

		$screen_name     = isset( $_GET['screen'] ) ? bbapp_input_clean( wp_unslash( $_GET['screen'] ) ) : 'home'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$platform_active = Appearance::instance()->get_branding_platform_preview(); // // Get default platform preview.

		Appearance::instance()->save_branding_platform_preview( $platform_active ); // Saved default platform preview.
		$screen_name = str_replace( '_', '-', $screen_name );

		ob_start();
		include bbapp()->plugin_dir . "views/preview/screens/{$screen_name}.php";
		$html = ob_get_clean();

		wp_send_json_success( array( 'html' => $html ) );
	}
}
