<?php
/**
 * User Segment
 *
 * @since   1.5.2.1
 * @package BuddyBossApp\AccessControls
 */

namespace BuddyBossApp\AccessControls;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Segment Class.
 *
 * @since 1.5.2.1
 */
class Segment extends SegmentsAbstract {

	/**
	 * Access control segment constructor.
	 *
	 * @since 1.5.2.1
	 */
	public function __construct() {
		$access_groups = bb_access_controls_get_groups( array( 'status' => array( 'enabled' ) ) );
		$group_options = array();

		if ( ! empty( $access_groups['result'] ) ) {
			foreach ( $access_groups['result'] as $access_group ) {
				$group_options[ esc_attr( $access_group['id'] ) ] = esc_html( $access_group['name'] );
			}
		}

		$this->add_filter( 'access_controls', 'user_access_group', array( 'access_group_select' ) );

		$this->add_field(
			'access_group_select',
			'Checkbox',
			array(
				'options'       => $group_options,
				'multiple'      => true,
				'title'         => __( 'If the member is enrolled in any of these Access Groups', 'buddyboss-app' ),
				'empty_message' => __( 'No access groups found.', 'buddyboss-app' ),
			)
		);

		$this->load();
	}

	/**
	 * Function to filter user for provided group ids.
	 *
	 * @param array $r_users_ids User ids.
	 *
	 * @since 1.5.2.1
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ) {
		$filter   = $this->get_filter_data_value( 'filter' );
		$user_ids = array();

		switch ( $filter ) {
			case 'access_controls_user_access_group':
				$group_ids = (array) $this->get_filter_data_value( 'access_group_select' );

				if ( $group_ids ) {
					$group_members = bb_access_controls_get_group_members(
						array(
							'status'        => array( 'enabled' ),
							'group_include' => $group_ids,
						)
					);
					$user_ids      = ( ! empty( $group_members['result'] ) ) ? array_unique( wp_list_pluck( $group_members['result'], 'user_id' ) ) : array();
				} else {
					$user_ids = array();
				}
				break;
		}

		if ( ! empty( $user_ids ) ) {
			return $user_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 *
	 * @since 1.5.2.1
	 *
	 * @return void
	 */
	public function render_script() {
		// TODO: Implement render_script() method.
	}
}
