<?php
/**
 * Holds WordPress page Listing.
 *
 * @package BuddyBossApp\AccessControls\Core\Settings
 */

namespace BuddyBossApp\AccessControls\Core\Settings;

use BuddyBossApp\AccessControls\AccessRule;
use BuddyBossApp\AccessControls\Core\List_Table;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Pages custm list.
 */
class PagesList extends List_Table {

	/**
	 * Class constructor
	 *
	 * @since 1.5.2.1
	 */
	public function __construct() {

		parent::__construct(
			Pages::instance()->post_type,
			array(
				'singular'              => _x( 'Page', 'access controls page integration settings', 'buddyboss-app' ), // singular name of the listed records.
				'plural'                => _x( 'Pages', 'access controls pages integration settings', 'buddyboss-app' ), // plural name of the listed records.
				'ajax'                  => false, // should this table support ajax?
				'screen'                => Pages::instance()->screen_name,
				'column_slug'           => 'page',
				'column_title'          => _x( 'Page', 'access controls pages integration settings', 'buddyboss-app' ),
				'column_inherited_hide' => true,
			)
		);
	}

	/**
	 * No page found
	 *
	 * @since 1.5.2.1
	 */
	public function no_items() {
		esc_html_e( 'No access page found.', 'buddyboss-app' );
	}

	/**
	 * Pages column custom values.
	 *
	 * @param object $item Page item.
	 *
	 * @since 1.5.2.1
	 *
	 * @return string|void
	 */
	public function column_page( $item ) {
		$output = '';

		$title = $item->post_title;
		if ( empty( $title ) ) {
			$title = _x( '(no title)', 'access controls pages integration settings', 'buddyboss-app' );
		}

		if ( current_user_can( 'edit_posts', $item->ID ) ) {
			$output .= '<strong><a href="' . get_edit_post_link( $item->ID ) . '">' . apply_filters( 'the_title', $title, $item->ID ) . '</a></strong>';
		} else {
			$output .= '<strong>' . apply_filters( 'the_title', $title, $item->ID ) . '</strong>';
		}
		echo wp_kses_post( $output );
	}

}
