<?php
/**
 * Holds Appage pages list.
 *
 * @package BuddyBossApp\AccessControls\Core\Settings
 */

namespace BuddyBossApp\AccessControls\Core\Settings;

use BuddyBossApp\AccessControls\AccessRule;
use BuddyBossApp\AccessControls\Core\List_Table;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * App page custom list.
 */
class AppPagesList extends List_Table {

	/**
	 * Class constructor
	 *
	 * @since 1.5.2.1
	 */
	public function __construct() {
		parent::__construct(
			AppPages::instance()->post_type,
			array(
				// singular name of the listed records.
				'singular'              => _x( 'App Page', 'access controls app page integration settings', 'buddyboss-app' ),
				// plural name of the listed records.
				'plural'                => _x( 'App Pages', 'access controls app page integration settings', 'buddyboss-app' ),
				// should this table support ajax?
				'ajax'                  => false,
				'screen'                => AppPages::instance()->screen_name,
				'column_slug'           => 'app_page',
				'column_title'          => _x( 'App Page', 'access controls app page integration settings', 'buddyboss-app' ),
				'column_inherited_hide' => true,
			)
		);
	}

	/**
	 * No app page found
	 *
	 * @since 1.5.2.1
	 */
	public function no_items() {
		esc_html_e( 'No access app page found.', 'buddyboss-app' );
	}

	/**
	 * App Pages column custom values.
	 *
	 * @param object $item App page item.
	 *
	 * @since 1.5.2.1
	 *
	 * @return string|void
	 */
	public function column_app_page( $item ) {
		$output = '';
		$title  = $item->post_title;

		if ( empty( $title ) ) {
			$title = _x( '(no title)', 'access controls general settings', 'buddyboss-app' );
		}

		if ( current_user_can( 'edit_posts', $item->ID ) ) {
			$output .= '<strong><a href="' . get_edit_post_link( $item->ID ) . '">' . apply_filters( 'the_title', $title, $item->ID ) . '</a></strong>';
		} else {
			$output .= '<strong>' . apply_filters( 'the_title', $title, $item->ID ) . '</strong>';
		}

		echo wp_kses_post( $output );
	}

}
