jQuery(document).ready(function($) {
    // Tab switching
    $('.bb-analytics-tabs .nav-tab-wrapper a').on('click', function(e) {
        e.preventDefault();
        
        // Update active tab
        $('.nav-tab-wrapper a').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        // Show corresponding content
        const target = $(this).attr('href');
        $('.bb-tab-content').removeClass('active');
        $(target).addClass('active');
    });
    
    // Initialize Members Growth Chart
    if ($('#membersGrowthChart').length) {
        const ctx = document.getElementById('membersGrowthChart').getContext('2d');
        const growthData = bbAnalyticsData.membersGrowth;
        
        const labels = growthData.map(item => item.month);
        const newMembers = growthData.map(item => item.count);
        const totalMembers = growthData.map(item => item.running_total);
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'New Members',
                        data: newMembers,
                        borderColor: '#2271b1',
                        backgroundColor: 'rgba(34, 113, 177, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.3
                    },
                    {
                        label: 'Total Members',
                        data: totalMembers,
                        borderColor: '#d63638',
                        backgroundColor: 'rgba(214, 54, 56, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.3
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': ' + context.raw.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }
});