<?php

if ( isset( $_REQUEST[ "nodes" ] ) ) {
  require_once __DIR__ . '/../../../wp-load.php';
  global $wpdb;

  /*
   project table => "wprsiun_bp_groups" (has creator_id)
   table rel term_id/project_id => "wprsiun_term_relationships"
   term name => "wprsiun_terms"
   term rel with users => "wprsiun_term_taxonomy"
  */


  //category
  $termsQuery = "SELECT
  term.term_id as id,
  term.slug as slug,
  term.name as name
  FROM wprsiun_term_taxonomy as taxonomy
  INNER JOIN wprsiun_terms as term on taxonomy.term_id = term.term_id";

  $projectsQuery = "SELECT
  project.id as id,
  project.name as name,
  project.creator_id as creatorId,
  categoryRel.term_taxonomy_id as categoryId,
  category.slug as categoryName
  FROM wprsiun_bp_groups as project
  INNER JOIN wprsiun_bp_xprofile_data as creator on creator.user_id = project.creator_id
  INNER JOIN wprsiun_term_relationships as categoryRel on categoryRel.object_id = project.id
  INNER JOIN wprsiun_terms as category on category.term_id = categoryRel.term_taxonomy_id
  GROUP BY id,name,creatorId,categoryId
  ";

  $results = [];
  $results = $wpdb->get_results( $projectsQuery );

  header( "Content-type: application/json; charset: utf-8" );
  echo json_encode( $results );
  exit( 0 );
}

// function sameDomain () { //not very reliable
//   $myDomain = $_SERVER[ 'SCRIPT_URI' ];
//   $requestsSource = $_SERVER[ 'HTTP_REFERER' ];
//
//   return parse_url( $myDomain, PHP_URL_HOST ) === parse_url( $requestsSource, PHP_URL_HOST );
// }
