var network;
var nodes;
var edges;

window.onload = function (e) {

    nodes = new vis.DataSet([]);
    edges = new vis.DataSet([]);

    var container = document.getElementById('mynetwork');
    var data = {
        nodes: nodes,
        edges: edges
    };

    var options = {
        nodes: {
            shape: 'dot',
            size: 25
            /*,opacity: 0.5*/
        },
        interaction: {
            hover: true,
            hoverConnectedEdges: false,
            //tooltipDelay: 1000,
            //zoomView: true,
            //navigationButtons: true,
            //keyboard: true,
        }
    };

    network = new vis.Network(container, data, options);

    var lastclick = 0; //to know the last node click on the network
    var nodehover = 0; //to know the ID of the node


    network.on("click", function (params) {
        var nodeID = params['nodes']['0'];
        if (nodeID) {
            var ids = params.nodes;
            var clickedNodes = nodes.get(ids);
            window.location.href = '/members/' + clickedNodes[0]['link'] + '/';
        }
    });


    var xx = 0, lastxx = 0;
    var yy = 0, lastyy = 0;
    var count = 0;

    window.onmousewheel = document.onmousewheel = mouseScroll;

    if (document.addEventListener) {
        document.addEventListener('DOMMouseScroll', mouseScroll, false);
    }

    function mouseScroll(e) {
        if (e.pageX == xx) { count++ } else { xx = e.pageX; count = 0; }
        if (e.pageY == yy) { count++ } else { yy = e.pageY; count = 0; }

        if (count >= 4) {
            if (e.pageX == xx) { lastxx = xx }
            if (e.pageY == yy) { lastyy = yy }
        }
    }

    var hey = [];

    $("body").mousemove(function (e) {
        hey = network.getViewPosition();
    })

    //NetWork on Zoom
    network.on("zoom", function (params) {
        lastheyx = 0;
        lastheyy = 0;
        if (network.getScale() <= 0.80 || network.getScale() > 2.00) {
            if (lastxx != xx || lastyy != yy) {
                hey = network.getViewPosition();
            }
        }
        else {
            hey = network.getViewPosition();
        }

        if (network.getScale() <= 0.80) {
            if (lastxx == xx && lastyy == yy) {
                network.moveTo({
                    position: { x: hey.x, y: hey.y },
                    scale: 0.80,
                });
            }
            else {
                network.moveTo({
                    position: { x: hey.x, y: hey.y },
                    scale: 0.80,
                });
            }
        }
        if (network.getScale() >= 2.00) {

            network.moveTo({
                position: { x: hey.x, y: hey.y },
                scale: 2.00,
            });
        }
    });


    var items;

    network.on("hoverNode", function (params) {
        var nodeID = params.node;
        nodehover = nodeID;
        nodes.update({
            id: nodeID,
            size: 35
        });
    });


    var count = 0;
    var users = [];
    var userExists;

    var noline;

    creatorNodes.forEach(function (element) {
        userExists = 0;//0 user no exist __ 1 user already exist
        noline = 0;//if already pass this id do nothing

        var user = [];
        user[3] = element.categoryID
        user[4] = element.categoryName
        user[6] = element.color
        user[2] = element.creatorID
        user[7] = element.creatorName
        user[0] = element.id
        user[5] = element.img
        user[1] = element.name
        user[8] = element.nicename
        //user[8] = element.user_slug.replace(window.location.origin+'/author','')

        nodes.add({ id: user[2], color: { border: 'white' }, font: { color: 'white' }, label: user[7], shape: 'circularImage', image: (user[5] != null && user[5] != undefined) ? user[5] : window.location.origin + '/wp-content/uploads/avatars/1/63caa09e43aa7-bpthumb.png', borderWidth: 4, title: user[1], link: user[8], catId: user[3], catName: user[4] });


        users.push(user[2]);
        count++;

        last_usr = user[2];//last user
        last_cat = user[3];//last category
        network.fit();
    });

    setRelationEdges(edges);
    setFilterDropDown();
    checkBrowserBack();
}


function setRelationEdges(edges) {
    for (const relationEdge of relationEdges) {
        var elem = {
            'id': relationEdge['id'],
            'from': relationEdge['leader_id'],
            'to': relationEdge['follower_id'],
            width: 3,
            color: { color: '#337ab7' }
        };
        edges.add(elem);
    }
    network.fit();
}


function setFilterDropDown() {
    var filterDropdown = document.getElementById('network-filter-dropdown');
    if (filterDropdown != undefined && filterDropdown.length !== 0) {
        filterDropdown.addEventListener('change', function () {
            network.body.data.nodes.clear();
            filteredNodes = this.value ? creatorNodes.filter(e => e.categoryName == this.value) : creatorNodes;
            filteredNodes.forEach(function (element) {
                nodes.add({
                    id: element.creatorID,
                    color: { border: 'white' },
                    font: { color: 'white' },
                    label: element.creatorName,
                    shape: 'circularImage',
                    image: (element.img != null && element.img != undefined) ? element.img : window.location.origin + '/wp-content/uploads/avatars/1/63caa09e43aa7-bpthumb.png',
                    borderWidth: 4,
                    title: element.name,
                    link: element.nicename,
                    catId: element.categoryID,
                    catName: element.categoryName
                });
            })
        })
    }
}

function checkBrowserBack() {
    var selectedFilter = document.getElementById("network-filter-dropdown").value;
    if (selectedFilter) {
        //when browser back it should check selection
        document.getElementById("network-filter-dropdown").dispatchEvent(new Event('change'));
    }
}


