<?php

/**
 * Displays a modal when clicking the "Manage Team" button.
 *
 * @copyright StellarWP
 * @package LeanDashGrupsPlus
 *
 * phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
 */

use LearnDash\Groups_Plus\Module\Group;

$user_id          = get_current_user_id();
$group_course_ids = array();
if ( Group::$parent_group_id ) {
	$group_course_ids = learndash_get_groups_courses_ids( $user_id, array( Group::$parent_group_id ) );
}

$course_orderby = get_site_option( 'course_orderby' ) ?? 'title';
$course_order   = get_site_option( 'course_order' ) ?? 'ASC';

$form_id = 'add_team';
$args    = array(
	'numberposts' => -1,
	'post_type'   => 'sfwd-courses',
	'orderby'     => $course_orderby,
	'post__in'    => $group_course_ids,
	'order'       => $course_order,
);

$courses = ! empty( $group_course_ids ) ? get_posts( $args ) : array();
?>

<!-- The Modal for Managing Organization (adding teams) -->
<div id="edit_groups_plus_init_modal"></div>
<div id="<?php echo esc_attr( $form_id ); ?>_modal" class="groups-plus-modal">
	<!-- Modal content -->
	<div class="groups-plus-modal-content">
		<div class="groups-plus-modal-nav">
			<ul class="tabs">
				<?php
				$hide_organization_manage_groups_plus_tab = get_site_option( 'hide_organization_manage_groups_plus_tab', 'no' );
				if ( $hide_organization_manage_groups_plus_tab === 'no' ) :
					?>
					<li class="tab-link current" data-tab="tab-manage-groups-plus">
						<?php printf(
							esc_html__( 'Manage %s', 'learndash-groups-plus' ),
							learndash_get_custom_label( 'team' )
						); ?>
					</li>
				<?php endif; ?>

				<?php
				$hide_organization_add_team_tab = get_site_option( 'hide_organization_add_team_tab', 'no' );
				if ( $hide_organization_add_team_tab === 'no' ) :
					?>
					<li class="tab-link" data-tab="tab-add-groups-plus">
						<?php printf(
							esc_html__( 'Add %s', 'learndash-groups-plus' ),
							learndash_get_custom_label( 'team' )
						); ?>
					</li>
				<?php endif; ?>
			</ul>
			<button class="tab-link groups-plus-close">&times;</button>
		</div>
		<div class="groups-plus-modal-container with-tab">
			<div id="tab-manage-groups-plus" class="tab-content current">
				<div class="form_message"></div>
				<table id="table-groups-plus-list" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-organization-delete-team' ); ?>">
					<thead>
						<tr>
							<th>
								<?php printf(
									esc_html__( '%s Name', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team' )
								); ?>
							</th>
							<th>
								<?php printf(
									esc_html__( '%s Total', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_member' )
								); ?>
							</th>
							<th><?php _e( 'Action', 'learndash-groups-plus' ); ?></th>
						</tr>
					</thead>
					<tbody id="tbody-groups-plus-list">
					</tbody>
				</table>
			</div>
			<div id="tab-add-groups-plus" class="tab-content">
				<form action="" method="POST" id="<?php echo $form_id; ?>" class="from-modal" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-organization-add-team' ); ?>">
					<div class="form_message"></div>
					<div class="form-group section">
						<div class="col grid_1_of_4">
							<input type="hidden" name="group" value="0" />
							<input type="text" name="groups_plus_group_name" value="" placeholder="<?php printf(
								esc_html__( 'Enter %s Name *', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team' )
							); ?>" autocomplete="off" />
						</div>
						<div class="col grid_2_of_4 div-has_team_leader_exists">
							<input type="checkbox" id="has_team_leader_exists" name="has_team_leader_exists" value="1">
							<label for="has_team_leader_exists">
								<?php printf(
									esc_html__( '%s already exists?', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>
							</label>
						</div>
					</div>
					<div class="form-group section div-has-team-leader">
						<div class="col grid_1_of_4">
							<select name="groups_plus_team_leader_ids[]" multiple="multiple" class="groups_plus_team_leader_ids form-control">
								<option value="">
									<?php printf(
										esc_html__( '-- Choose %s --', 'learndash-groups-plus' ),
										learndash_get_custom_label_lower( 'team_leaders' )
									); ?>
								</option>
								<?php
								$allow_leader_to_see_all_users = get_site_option( 'allow_leader_to_see_all_users' );
								if ( $allow_leader_to_see_all_users ) {
									$child_groups_administrators = learndash_groups_plus_get_group_leaders();
								} else {
									$child_groups_administrators = get_child_groups_administrators( Group::$parent_group_id );
								}
								foreach ( $child_groups_administrators as $admin_id => $child_groups_administrators ) {
									?>
									<option value="<?php _e( $admin_id, 'learndash-groups-plus' ); ?>">
										<?php _e( $child_groups_administrators['display_name'], 'learndash-groups-plus' ); ?></option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class=" div-new-team-leader">
						<div class="form-group section">
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_firstname" value="" placeholder="<?php printf(
									esc_attr__( '%s Firstname *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_lastname" value="" placeholder="<?php printf(
									esc_attr__( '%s Lastname *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_username" value="" placeholder="<?php printf(
									esc_attr__( '%s Username *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
						</div>
						<div class="form-group section">
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_email" value="" placeholder="<?php printf(
									esc_attr__( '%s Email *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
							<div class="col grid_1_of_4 text-right">
								<label class="classrrom-form-label text-center"><?php _e( 'Password', 'learndash-groups-plus' ); ?>:</label>
							</div>
							<div class="col grid_1_of_4">

								<input type="text" name="groups_plus_team_leader_password" class="form_password" value="<?php echo esc_attr( generate_team_member_password() ); ?>" placeholder="<?php esc_html_e( 'Password *', 'learndash-groups-plus' ); ?>" autocomplete="off" />
							</div>
						</div>
					</div>
					<div class="form-group section">
						<div class="col grid_2_of_5 ">

							<label class="groups-plus-form-label text-center"><?php esc_html_e( 'Available Courses', 'learndash-groups-plus' ); ?></label>
							<input type="text" class="courses_search_box" placeholder="<?php _e( 'Search for names...', 'learndash-groups-plus' ); ?>" title="Type in a name" />
							<select class="groups-plus-courses-select" id="listcoursesSelectBox" multiple>
								<?php foreach ( $courses as $course ) { ?>
									<option value="<?php esc_attr_e( $course->ID, 'learndash-groups-plus' ); ?>">
										<?php esc_html_e( $course->post_title, 'learndash-groups-plus' ); ?>
									</option>
								<?php } ?>
							</select>

							<select class="" id="listcoursesHidden" style="display:none;">
								<?php foreach ( $courses as $course ) { ?>
									<option value="<?php esc_attr_e( $course->ID, 'learndash-groups-plus' ); ?>">
										<?php esc_html_e( $course->post_title, 'learndash-groups-plus' ); ?>
									</option>
								<?php } ?>
							</select>
						</div>
						<div class="col grid_1_of_5">
							<div class="groups-plus-courses-actions">
								<a href="#" id="btnAddCourse" class="btnAddCourse"><img src="<?php echo LEARNDASH_GROUPS_PLUS_URL . 'build/images/c_arrow_right.png'; ?>" /></a>
								<br>
								<a href="#" id="btnRemoveCourse" class="btnRemoveCourse">
									<img src="<?php echo LEARNDASH_GROUPS_PLUS_URL . 'build/images/c_arrow_left.png'; ?>" />
								</a>
							</div>
						</div>
						<div class="col grid_2_of_5">
							<label class="groups-plus-form-label text-center"><?php esc_html_e( 'Active Courses', 'learndash-groups-plus' ); ?></label>
							<input type="text" class="courses_search_box" placeholder="<?php _e( 'Search for names...', 'learndash-groups-plus' ); ?>" title="Type in a name" />
							<select class="groups-plus-courses-select" name="courses[]" id="coursesSelectBox" multiple>
							</select>
						</div>
					</div>
					<div class="form-action section text-right">
						<div class="col grid_1_of_4 pull-right">
							<button type="submit" class="btn_groups_plus" id="<?php echo $form_id; ?>_btn"><?php esc_html_e( 'Save', 'learndash-groups-plus' ); ?><i class="fa fa-angle-right"></i></button>
						</div>
					</div>
					<div class="form-action section text-right">
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<!--- Modal of add team leader email -->
<?php $form_id = 'add-team-leader-email-groups-plus'; ?>
<div id="<?php echo $form_id; ?>_modal" class="groups-plus-modal">
	<!-- Modal content -->
	<div class="groups-plus-modal-content">
		<?php
		$team_leader_email_data = get_user_meta( $user_id, 'team_leader_email_data', true );
		if ( empty( $team_leader_email_data ) ) {
			$team_leader_email_data = array();
		}
		extract( $team_leader_email_data );
		?>
		<div class="groups-plus-modal-nav">
			<ul class="tabs">
				<?php
				$hide_organization_broadcast_email_tab = get_site_option( 'hide_organization_broadcast_email_tab', 'no' );
				if ( $hide_organization_broadcast_email_tab === 'no' ) {
					?>
					<li class="tab-link current" data-tab="tab-2">
						<?php esc_html_e( 'Broadcast Email', 'learndash-groups-plus' ); ?>
					</li>
				<?php } ?>

				<?php
				$hide_organization_welcome_email_tab = get_site_option( 'hide_organization_welcome_email_tab', 'no' );
				if ( $hide_organization_welcome_email_tab === 'no' ) {
					?>
					<li class="tab-link" data-tab="tab-1">
						<?php printf(
							esc_html__( '%s Welcome Email', 'learndash-groups-plus' ),
							learndash_get_custom_label( 'team_leader' )
						); ?>
					</li>
				<?php } ?>
			</ul>
			<button class="tab-link groups-plus-close">&times;</button>
		</div>

		<div class="groups-plus-modal-container with-tab">
			<div id="tab-1" class="tab-content">
				<h5 style="margin-bottom:10px;">
					<?php printf(
						esc_html__( 'Configure %s welcome email', 'learndash-groups-plus' ),
						learndash_get_custom_label( 'team_leader' )
					); ?>
				</h5>
				<p class="para">
					<?php printf(
						esc_html__( 'This email template will be sent when you add new %s', 'learndash-groups-plus' ),
						learndash_get_custom_label_lower( 'team_leaders' )
					); ?>
				</p>
				<br />
				<h6><?php _e( 'Available merge codes', 'learndash-groups-plus' ); ?>:</h6>
				<table class="modal-table">
					<tr>
						<td class="para italic">
							<?php _e( 'Insert name of Parent Group', 'learndash-groups-plus' ); ?>:<code>{group_name}</code>
						</td>
						<td class="para italic">
							<?php _e( 'Insert name of child-group', 'learndash-groups-plus' ); ?>:<code>{childgroup_name}</code>
						</td>
						<td class="para italic">
							<?php printf(
								esc_html__( 'Insert name of %s', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team_leader' )
							); ?>: <code>{team_leader_name}</code>
						</td>
						<td class="para italic">
							<?php printf(
								esc_html__( 'Insert username of %s', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team_leader' )
							); ?>: <code>{team_leader_username}</code>
						</td>
						<td class="para italic">
							<?php printf(
								esc_html__( 'Insert password of %s', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team_leader' )
							); ?>: <code>{password}</code>
						</td>
						<td class="para italic">
							<?php printf(
								esc_html__( 'Autologin link of %s', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team_leader' )
							); ?>: <code>{autologin}</code>
						</td>
					</tr>
				</table>
				<br />
				<h5>
					<?php printf(
						esc_html__( '%s Invitation Email', 'learndash-groups-plus' ),
						learndash_get_custom_label( 'team_leader' )
					); ?>
				</h5>
				<form action="" method="POST" id="<?php echo $form_id; ?>" class="from-modal" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-organization-add-team-leader-welcome-email' ); ?>">
					<div class="form_message"></div>
					<div class="form-group">
						<label class=""><?php esc_html_e( 'Subject', 'learndash-groups-plus' ); ?>:</label>
						<input type="text" name="team_leader_email_subject" value="<?php echo isset( $team_leader_email_subject ) ? esc_attr( $team_leader_email_subject ) : ''; ?>" placeholder="<?php esc_html_e( 'Subject', 'learndash-groups-plus' ); ?>" autocomplete="off" />

						<label class="modal-editor-label"><?php esc_html_e( 'Body', 'learndash-groups-plus' ); ?>:</label>
						<?php
						$content   = isset( $team_leader_email_body ) ? $team_leader_email_body : '';
						$editor_id = 'team_leader_email_body';
						$settings  = array(
							'media_buttons' => false,
							'wpautop'       => false,
						);
						wp_editor( $content, $editor_id, $settings );
						?>
					</div>
					<div class="form-action text-right">
						<button type="submit" class="btn_groups_plus" id="<?php echo $form_id; ?>_btn"><?php esc_html_e( 'Save', 'learndash-groups-plus' ); ?>
							<i class="fa fa-angle-right"></i></button>
					</div>
				</form>
			</div>
			<div id="tab-2" class="tab-content current">
				<?php $form_id = 'send_broadcast_email_to_team_leaders'; ?>
				<h5 style="margin-bottom:10px;">
					<?php printf(
						esc_html__( 'Configure %s broadcast email', 'learndash-groups-plus' ),
						learndash_get_custom_label( 'team_leaders' )
					); ?>
				</h5>
				<p class="para">
					<?php printf(
						esc_html__( 'This email will be sent immediately to all %s', 'learndash-groups-plus' ),
						learndash_get_custom_label_lower( 'team_leaders' )
					); ?>
				</p>
				<br />
				<h6><?php _e( 'Available merge codes', 'learndash-groups-plus' ); ?>:</h6>
				<table class="modal-table">
					<tr>
						<td class="para italic">
							<?php _e( 'Insert name of Parent Group', 'learndash-groups-plus' ); ?>:<code>{group_name}</code>
						</td>
						<td class="para italic">
							<?php _e( 'Insert name of child-group', 'learndash-groups-plus' ); ?>:<code>{childgroup_name}</code>
						</td>
						<td class="para italic">
							<?php printf(
								esc_html__( 'Insert name of %s', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team_leader' )
							); ?>: <code>{team_leader_name}</code>
						</td>
						<td class="para italic">
							<?php printf(
								esc_html__( 'Insert username of %s', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team_leader' )
							); ?>: <code>{team_leader_username}</code>
						</td>
					</tr>
				</table>
				<br />
				<h5>
					<?php printf(
						esc_html__( '%s Broadcast Email', 'learndash-groups-plus' ),
						learndash_get_custom_label( 'team_leaders' )
					); ?>:
				</h5>
				<form action="" method="POST" id="<?php echo $form_id; ?>" class="from-modal" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-send-broadcast-email-to-team-leaders' ); ?>">
					<div class="form_message"></div>
					<div class="form-group">
						<label class=""><?php esc_html_e( 'Subject', 'learndash-groups-plus' ); ?>:</label>
						<input type="text" name="team_leader_b_email_subject" value="" placeholder="<?php esc_html_e( 'Subject', 'learndash-groups-plus' ); ?>" autocomplete="off" />

						<label class="modal-editor-label"><?php esc_html_e( 'Body', 'learndash-groups-plus' ); ?>:</label>
						<?php
						$content   = '';
						$editor_id = 'team_leader_b_email_body';
						$settings  = array(
							'media_buttons' => false,
							'wpautop'       => false,
						);
						wp_editor( $content, $editor_id, $settings );
						?>
					</div>
					<div class="form-action text-right">
						<button type="submit" class="btn_groups_plus" id="<?php echo $form_id; ?>_btn"><?php esc_html_e( 'Send', 'learndash-groups-plus' ); ?>
							<i class="fa fa-angle-right"></i></button>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>

<!--- Modal of manage courses -->
<?php $form_id = 'manage_groups_plus_courses'; ?>
<div id="<?php echo $form_id; ?>_modal" class="groups-plus-modal">
	<!-- Modal content -->
	<div class="groups-plus-modal-content">
		<div class="groups-plus-modal-nav">
			<ul class="tabs">
				<li class="tab-link current" data-tab="tab-manage-groups-plus">
					<?php esc_html_e( 'Manage Courses', 'learndash-groups-plus' ); ?>
				</li>
			</ul>
			<button class="groups-plus-close">&times;</button>
		</div>
		<div class="groups-plus-modal-container">
			<form action="" method="POST" id="<?php echo $form_id; ?>" class="from-modal" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-team-courses' ); ?>">
				<div class="form_message"></div>
				<div class="form-group section">
					<div class="col grid_2_of_5 ">
						<input type="hidden" name="group" value="0" />
						<label class="classrrom-form-label text-center"><?php esc_html_e( 'Available Courses', 'learndash-groups-plus' ); ?></label>
						<input type="text" class="courses_search_box" placeholder="<?php _e( 'Search for names...', 'learndash-groups-plus' ); ?>" title="Type in a name" />
						<select class="groups-plus-courses-select" id="listcoursesSelectBox" multiple>
							<?php foreach ( $courses as $course ) { ?>
								<option value="<?php esc_attr_e( $course->ID, 'learndash-groups-plus' ); ?>">
									<?php esc_html_e( $course->post_title, 'learndash-groups-plus' ); ?>
								</option>
							<?php } ?>
						</select>

						<select class="" id="listcoursesHidden" style="display:none;">
							<?php foreach ( $courses as $course ) { ?>
								<option value="<?php esc_attr_e( $course->ID, 'learndash-groups-plus' ); ?>">
									<?php esc_html_e( $course->post_title, 'learndash-groups-plus' ); ?>
								</option>
							<?php } ?>
						</select>
					</div>
					<div class="col grid_1_of_5">
						<div class="groups-plus-courses-actions">
							<a href="#" id="btnAddCourse" class="btnAddCourse"><img src="<?php echo LEARNDASH_GROUPS_PLUS_URL . 'build/images/c_arrow_right.png'; ?>" /></a>
							<br>
							<a href="#" id="btnRemoveCourse" class="btnRemoveCourse">
								<img src="<?php echo LEARNDASH_GROUPS_PLUS_URL . 'build/images/c_arrow_left.png'; ?>" />
							</a>
						</div>
					</div>
					<div class="col grid_2_of_5">
						<label class="classrrom-form-label text-center"><?php esc_html_e( 'Active Courses', 'learndash-groups-plus' ); ?></label>
						<input type="text" class="courses_search_box" placeholder="<?php _e( 'Search for names...', 'learndash-groups-plus' ); ?>" title="Type in a name" />
						<select class="groups-plus-courses-select" name="courses[]" id="coursesSelectBox" multiple>
						</select>
					</div>
				</div>
				<div class="form-action section text-right">
					<div class="col grid_1_of_4 pull-right">
						<button type="submit" class="btn_groups_plus" id="<?php echo $form_id; ?>_btn"><?php esc_html_e( 'Save', 'learndash-groups-plus' ); ?><i class="fa fa-angle-right"></i></button>
					</div>
				</div>
				<div class="form-action section text-right">
				</div>
			</form>
		</div>
	</div>
</div>



<!--- Modal of manage team leaders -->
<?php $form_id = 'manage_groups_plus_add_team_leaders'; ?>
<div id="<?php echo $form_id; ?>_modal" class="groups-plus-modal">
	<!-- Modal content -->
	<div class="groups-plus-modal-content">

		<div class="groups-plus-modal-nav">
			<ul class="tabs">
				<?php
				$hide_organization_manage_team_leaders_tab = get_site_option( 'hide_organization_manage_team_leaders_tab', 'no' );
				if ( $hide_organization_manage_team_leaders_tab === 'no' ) : ?>
					<li class="tab-link current" data-tab="tab-manage-team-leaders">
						<?php printf(
							esc_html__( 'Manage %s', 'learndash-groups-plus' ),
							learndash_get_custom_label( 'team_leaders' )
						); ?>
					</li>
				<?php endif; ?>

				<?php
				$hide_organization_add_team_leaders_tab = get_site_option( 'hide_organization_add_team_leaders_tab', 'no' );
				if ( $hide_organization_add_team_leaders_tab === 'no' ) : ?>
					<li class="tab-link" data-tab="tab-add-team-leader">
						<?php printf(
							esc_html__( 'Add %s', 'learndash-groups-plus' ),
							learndash_get_custom_label( 'team_leaders' )
						); ?>
					</li>
				<?php endif; ?>

				<?php
				$hide_organization_add_team_leader_as_team_member_tab = get_site_option( 'hide_organization_add_team_leader_as_team_member_tab', 'no' );
				if ( $hide_organization_add_team_leader_as_team_member_tab === 'no' ) : ?>
					<li class="tab-link" data-tab="tab-be-a-team-member-as-a-team-leader">
						<?php printf(
							esc_html__( 'Add %1$s as %2$s', 'learndash-groups-plus' ),
							learndash_get_custom_label( 'team_leader' ),
							learndash_get_custom_label( 'team_member' ),
						); ?>
					</li>
				<?php endif; ?>
			</ul>
			<button class="tab-link groups-plus-close">&times;</button>
		</div>

		<div class="groups-plus-modal-container with-tab">
			<div id="tab-manage-team-leaders" class="tab-content current">
				<table id="table-team-leaders-list" data-group="" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-team-delete-team-leader' ); ?>">
					<thead>
						<tr>
							<th><?php _e( 'Firstname', 'learndash-groups-plus' ); ?></th>
							<th><?php _e( 'Lastname', 'learndash-groups-plus' ); ?></th>
							<th><?php _e( 'Username', 'learndash-groups-plus' ); ?></th>
							<th><?php _e( 'Email', 'learndash-groups-plus' ); ?></th>
							<th><?php _e( 'Action', 'learndash-groups-plus' ); ?></th>
						</tr>
					</thead>
					<tbody id="tbody-team-leaders-list">
					</tbody>
				</table>
			</div>
			<div id="tab-add-team-leader" class="tab-content">
				<form action="" method="POST" id="<?php echo $form_id; ?>" class="from-modal" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-team-add-team-leader' ); ?>">
					<div class="form_message"></div>
					<div class="form-group section">
						<div class="col grid_1_of_4">
							<input type="hidden" name="group" value="0" />
							<input type="hidden" name="groups_plus_team_leader_id" value="0" />
							<input type="text" name="groups_plus_group_name" value="" placeholder="<?php printf(
								esc_html__( 'Enter %s Name *', 'learndash-groups-plus' ),
								learndash_get_custom_label( 'team' )
							); ?>" readonly disabled autocomplete="off" />
						</div>
						<div class="col grid_2_of_4 div-has_team_leader_exists">
							<input type="checkbox" id="edit_has_team_leader_exists" name="has_team_leader_exists" value="1">
							<label for="edit_has_team_leader_exists">
								<?php printf(
									esc_html__( '%s already exists?', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>
							</label>
						</div>
					</div>
					<div class="form-group section div-has-team-leader">
						<div class="col grid_1_of_4">
							<select name="groups_plus_team_leader_ids[]" multiple="multiple" class="groups_plus_team_leader_ids form-control">
								<?php
								$allow_leader_to_see_all_users = get_site_option( 'allow_leader_to_see_all_users' );
								if ( $allow_leader_to_see_all_users ) {
									$child_groups_administrators = learndash_groups_plus_get_group_leaders();
								} else {
									$child_groups_administrators = get_child_groups_administrators( Group::$parent_group_id );
								}


								foreach ( $child_groups_administrators as $admin_id => $child_groups_administrator ) {
									?>
									<option value="<?php _e( $admin_id, 'learndash-groups-plus' ); ?>">
										<?php _e( $child_groups_administrator['display_name'], 'learndash-groups-plus' ); ?></option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class="div-new-team-leader">
						<div class="form-group section ">
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_firstname" value="" placeholder="<?php printf(
									esc_html__( '%s Firstname *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_lastname" value="" placeholder="<?php printf(
									esc_html__( '%s Lastname *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
						</div>
						<div class="form-group section ">
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_username" value="" placeholder="<?php printf(
									esc_html__( '%s Username *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_email" value="" placeholder="<?php printf(
									esc_html__( '%s Email *', 'learndash-groups-plus' ),
									learndash_get_custom_label( 'team_leader' )
								); ?>" autocomplete="off" />
							</div>

							<div class="col grid_1_of_6 text-right">
								<label class="classrrom-form-label text-center"><?php _e( 'Password', 'learndash-groups-plus' ); ?>:</label>
							</div>
							<div class="col grid_1_of_4">
								<input type="text" name="groups_plus_team_leader_password" class="form_password" value="<?php echo esc_attr( generate_team_member_password() ); ?>" placeholder="<?php esc_html_e( 'Password *', 'learndash-groups-plus' ); ?>" autocomplete="off" />
							</div>
						</div>
					</div>
					<div class="form-action section text-right">
						<div class="col grid_1_of_4 pull-right">
							<button type="submit" class="btn_groups_plus" id="<?php echo $form_id; ?>_btn"><?php esc_html_e( 'Save', 'learndash-groups-plus' ); ?><i class="fa fa-angle-right"></i></button>
						</div>
					</div>
					<div class="form-action section">

					</div>
				</form>
			</div>
			<div id="tab-be-a-team-member-as-a-team-leader" class="tab-content">
				<?php $form_id = 'manage_groups_plus_be_a_team_member_as_a_team_leader'; ?>
				<form action="" method="POST" id="<?php echo $form_id; ?>" class="from-modal" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-team-add-team-leader-as-team-member' ); ?>">
					<div class="form_message"></div>
					<div class="form-group section">
						<div class="col grid_4_of_4">
							<h4>
								<strong>
									<?php printf(
										esc_html__( '%s Name', 'learndash-groups-plus' ),
										learndash_get_custom_label( 'team' )
									); ?>
								</strong>
								<span class="groups-plus-group-name"></span>
							</h4>
						</div>
					</div>
					<div class="form-group section">
						<div class="col grid_1_of_4">
							<input type="hidden" name="group" value="0" />
							<select name="groups_plus_team_leader_ids[]" multiple="multiple" class="groups_plus_team_leader_ids form-control">
								<?php
								// $child_groups_administrators = get_child_groups_administrator($parent_group_id);
								foreach ( $child_groups_administrators as $admin_id => $child_groups_administrator ) {
									?>
									<option value="<?php _e( $admin_id, 'learndash-groups-plus' ); ?>">
										<?php _e( $child_groups_administrator['display_name'], 'learndash-groups-plus' ); ?></option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class="form-group section">
						<div class="col grid_4_of_4">
							<table id="table-team-leaders-list" data-group="" data-nonce="<?php echo wp_create_nonce( 'learndash-groups-plus-manage-team-delete-team-leader-from-team-member' ); ?>">
								<thead>
									<tr>
										<th><?php _e( 'Firstname', 'learndash-groups-plus' ); ?></th>
										<th><?php _e( 'Lastname', 'learndash-groups-plus' ); ?></th>
										<th><?php _e( 'Username', 'learndash-groups-plus' ); ?></th>
										<th><?php _e( 'Email', 'learndash-groups-plus' ); ?></th>
										<th><?php _e( 'Action', 'learndash-groups-plus' ); ?></th>
									</tr>
								</thead>
								<tbody id="tbody-team-leaders-list">
								</tbody>
							</table>
						</div>
					</div>
					<div class="form-action section text-right">
						<div class="col grid_1_of_4 pull-right">
							<button type="submit" class="btn_groups_plus" id="<?php echo $form_id; ?>_btn"><?php esc_html_e( 'Save', 'learndash-groups-plus' ); ?><i class="fa fa-angle-right"></i></button>
						</div>
					</div>
					<div class="form-action section">

					</div>
				</form>
			</div>
		</div>
	</div>
</div>
