<?php
/**
 * This contains all the classes we use
 *
 * @file
 * @package Learndas_Certificate_Builder
 */

// class map, use for autoload.

$base_dir = dirname( __DIR__ );

$class_map = array(
	'Certificate_Builder\\Traits\\IO'                      => $base_dir . '/src/traits/io.php',
	'DeepCopy\\DeepCopy'                                   => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/DeepCopy.php',
	'DeepCopy\\Exception\\CloneException'                  => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Exception/CloneException.php',
	'DeepCopy\\Exception\\PropertyException'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Exception/PropertyException.php',
	'DeepCopy\\Filter\\Doctrine\\DoctrineCollectionFilter' => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine/DoctrineCollectionFilter.php',
	'DeepCopy\\Filter\\Doctrine\\DoctrineEmptyCollectionFilter' => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine/DoctrineEmptyCollectionFilter.php',
	'DeepCopy\\Filter\\Doctrine\\DoctrineProxyFilter'      => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine/DoctrineProxyFilter.php',
	'DeepCopy\\Filter\\Filter'                             => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Filter.php',
	'DeepCopy\\Filter\\KeepFilter'                         => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/KeepFilter.php',
	'DeepCopy\\Filter\\ReplaceFilter'                      => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/ReplaceFilter.php',
	'DeepCopy\\Filter\\SetNullFilter'                      => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/SetNullFilter.php',
	'DeepCopy\\Matcher\\Doctrine\\DoctrineProxyMatcher'    => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/Doctrine/DoctrineProxyMatcher.php',
	'DeepCopy\\Matcher\\Matcher'                           => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/Matcher.php',
	'DeepCopy\\Matcher\\PropertyMatcher'                   => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/PropertyMatcher.php',
	'DeepCopy\\Matcher\\PropertyNameMatcher'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/PropertyNameMatcher.php',
	'DeepCopy\\Matcher\\PropertyTypeMatcher'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/PropertyTypeMatcher.php',
	'DeepCopy\\Reflection\\ReflectionHelper'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Reflection/ReflectionHelper.php',
	'DeepCopy\\TypeFilter\\Date\\DateIntervalFilter'       => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/Date/DateIntervalFilter.php',
	'DeepCopy\\TypeFilter\\ReplaceFilter'                  => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/ReplaceFilter.php',
	'DeepCopy\\TypeFilter\\ShallowCopyFilter'              => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/ShallowCopyFilter.php',
	'DeepCopy\\TypeFilter\\Spl\\SplDoublyLinkedList'       => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/Spl/SplDoublyLinkedList.php',
	'DeepCopy\\TypeFilter\\Spl\\SplDoublyLinkedListFilter' => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/Spl/SplDoublyLinkedListFilter.php',
	'DeepCopy\\TypeFilter\\TypeFilter'                     => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/TypeFilter.php',
	'DeepCopy\\TypeMatcher\\TypeMatcher'                   => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeMatcher/TypeMatcher.php',
	'DeepCopy\\f001\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f001/A.php',
	'DeepCopy\\f001\\B'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f001/B.php',
	'DeepCopy\\f002\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f002/A.php',
	'DeepCopy\\f003\\Foo'                                  => $base_dir . '/external/myclabs/deep-copy/fixtures/f003/Foo.php',
	'DeepCopy\\f004\\UnclonableItem'                       => $base_dir . '/external/myclabs/deep-copy/fixtures/f004/UnclonableItem.php',
	'DeepCopy\\f005\\Foo'                                  => $base_dir . '/external/myclabs/deep-copy/fixtures/f005/Foo.php',
	'DeepCopy\\f006\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f006/A.php',
	'DeepCopy\\f006\\B'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f006/B.php',
	'DeepCopy\\f007\\FooDateInterval'                      => $base_dir . '/external/myclabs/deep-copy/fixtures/f007/FooDateInterval.php',
	'DeepCopy\\f007\\FooDateTimeZone'                      => $base_dir . '/external/myclabs/deep-copy/fixtures/f007/FooDateTimeZone.php',
	'DeepCopy\\f008\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f008/A.php',
	'DeepCopy\\f008\\B'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f008/B.php',
	'Error'                                                => $base_dir . '/external/paragonie/random_compat/lib/error_polyfill.php',
	'LearnDash_Certificate_Builder\\Bootstrap'             => $base_dir . '/src/class-bootstrap.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Block' => $base_dir . '/src/component/pdf/blocks/class-block.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Columns' => $base_dir . '/src/component/pdf/blocks/class-core-columns.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Heading' => $base_dir . '/src/component/pdf/blocks/class-core-heading.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Paragraph' => $base_dir . '/src/component/pdf/blocks/class-core-paragraph.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Spacer' => $base_dir . '/src/component/pdf/blocks/class-core-spacer.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Fallback' => $base_dir . '/src/component/pdf/blocks/class-fallback.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Quizinfo' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-quizinfo.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Courseinfo' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-courseinfo.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Groupinfo' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-groupinfo.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Usermeta' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-usermeta.php',
	'LearnDash_Certificate_Builder\\Component\\PDF'        => $base_dir . '/src/component/class-pdf.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Builder\\Builder' => $base_dir . '/src/component/pdf/builder/builder.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Builder\\Html_Builder' => $base_dir . '/src/component/pdf/builder/class-html-builder.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Builder\\Style_Builder' => $base_dir . '/src/component/pdf/builder/class-style-builder.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Pdf_Content' => $base_dir . '/src/component/pdf/class-pdf-content.php',
	'LearnDash_Certificate_Builder\\Controller\\Certificate_Builder' => $base_dir . '/src/controller/class-certificate-builder.php',
	'LearnDash_Certificate_Builder\\Controller\\Fonts_Manager' => $base_dir . '/src/controller/class-fonts-manager.php',
	'LearnDash_Certificate_Builder\\Controller\\Switcher'  => $base_dir . '/src/controller/class-switcher.php',
	'Mpdf\\Barcode'                                        => $base_dir . '/external/mpdf/mpdf/src/Barcode.php',
	'Mpdf\\Barcode\\AbstractBarcode'                       => $base_dir . '/external/mpdf/mpdf/src/Barcode/AbstractBarcode.php',
	'Mpdf\\Barcode\\BarcodeException'                      => $base_dir . '/external/mpdf/mpdf/src/Barcode/BarcodeException.php',
	'Mpdf\\Barcode\\BarcodeInterface'                      => $base_dir . '/external/mpdf/mpdf/src/Barcode/BarcodeInterface.php',
	'Mpdf\\Barcode\\Codabar'                               => $base_dir . '/external/mpdf/mpdf/src/Barcode/Codabar.php',
	'Mpdf\\Barcode\\Code11'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code11.php',
	'Mpdf\\Barcode\\Code128'                               => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code128.php',
	'Mpdf\\Barcode\\Code39'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code39.php',
	'Mpdf\\Barcode\\Code93'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code93.php',
	'Mpdf\\Barcode\\EanExt'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/EanExt.php',
	'Mpdf\\Barcode\\EanUpc'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/EanUpc.php',
	'Mpdf\\Barcode\\I25'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/I25.php',
	'Mpdf\\Barcode\\Imb'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/Imb.php',
	'Mpdf\\Barcode\\Msi'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/Msi.php',
	'Mpdf\\Barcode\\Postnet'                               => $base_dir . '/external/mpdf/mpdf/src/Barcode/Postnet.php',
	'Mpdf\\Barcode\\Rm4Scc'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Rm4Scc.php',
	'Mpdf\\Barcode\\S25'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/S25.php',
	'Mpdf\\Cache'                                          => $base_dir . '/external/mpdf/mpdf/src/Cache.php',
	'Mpdf\\Color\\ColorConverter'                          => $base_dir . '/external/mpdf/mpdf/src/Color/ColorConverter.php',
	'Mpdf\\Color\\ColorModeConverter'                      => $base_dir . '/external/mpdf/mpdf/src/Color/ColorModeConverter.php',
	'Mpdf\\Color\\ColorSpaceRestrictor'                    => $base_dir . '/external/mpdf/mpdf/src/Color/ColorSpaceRestrictor.php',
	'Mpdf\\Color\\NamedColors'                             => $base_dir . '/external/mpdf/mpdf/src/Color/NamedColors.php',
	'Mpdf\\Config\\ConfigVariables'                        => $base_dir . '/external/mpdf/mpdf/src/Config/ConfigVariables.php',
	'Mpdf\\Config\\FontVariables'                          => $base_dir . '/external/mpdf/mpdf/src/Config/FontVariables.php',
	'Mpdf\\Conversion\\DecToAlpha'                         => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToAlpha.php',
	'Mpdf\\Conversion\\DecToCjk'                           => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToCjk.php',
	'Mpdf\\Conversion\\DecToHebrew'                        => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToHebrew.php',
	'Mpdf\\Conversion\\DecToOther'                         => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToOther.php',
	'Mpdf\\Conversion\\DecToRoman'                         => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToRoman.php',
	'Mpdf\\CssManager'                                     => $base_dir . '/external/mpdf/mpdf/src/CssManager.php',
	'Mpdf\\Css\\Border'                                    => $base_dir . '/external/mpdf/mpdf/src/Css/Border.php',
	'Mpdf\\Css\\DefaultCss'                                => $base_dir . '/external/mpdf/mpdf/src/Css/DefaultCss.php',
	'Mpdf\\Css\\TextVars'                                  => $base_dir . '/external/mpdf/mpdf/src/Css/TextVars.php',
	'Mpdf\\DirectWrite'                                    => $base_dir . '/external/mpdf/mpdf/src/DirectWrite.php',
	'Mpdf\\Exception\\FontException'                       => $base_dir . '/external/mpdf/mpdf/src/Exception/FontException.php',
	'Mpdf\\Exception\\InvalidArgumentException'            => $base_dir . '/external/mpdf/mpdf/src/Exception/InvalidArgumentException.php',
	'Mpdf\\File\\StreamWrapperChecker'                     => $base_dir . '/external/mpdf/mpdf/src/File/StreamWrapperChecker.php',
	'Mpdf\\Fonts\\FontCache'                               => $base_dir . '/external/mpdf/mpdf/src/Fonts/FontCache.php',
	'Mpdf\\Fonts\\FontFileFinder'                          => $base_dir . '/external/mpdf/mpdf/src/Fonts/FontFileFinder.php',
	'Mpdf\\Fonts\\GlyphOperator'                           => $base_dir . '/external/mpdf/mpdf/src/Fonts/GlyphOperator.php',
	'Mpdf\\Fonts\\MetricsGenerator'                        => $base_dir . '/external/mpdf/mpdf/src/Fonts/MetricsGenerator.php',
	'Mpdf\\Form'                                           => $base_dir . '/external/mpdf/mpdf/src/Form.php',
	'Mpdf\\FpdiTrait'                                      => $base_dir . '/external/mpdf/mpdf/src/FpdiTrait.php',
	'Mpdf\\Gif\\ColorTable'                                => $base_dir . '/external/mpdf/mpdf/src/Gif/ColorTable.php',
	'Mpdf\\Gif\\FileHeader'                                => $base_dir . '/external/mpdf/mpdf/src/Gif/FileHeader.php',
	'Mpdf\\Gif\\Gif'                                       => $base_dir . '/external/mpdf/mpdf/src/Gif/Gif.php',
	'Mpdf\\Gif\\Image'                                     => $base_dir . '/external/mpdf/mpdf/src/Gif/Image.php',
	'Mpdf\\Gif\\ImageHeader'                               => $base_dir . '/external/mpdf/mpdf/src/Gif/ImageHeader.php',
	'Mpdf\\Gif\\Lzw'                                       => $base_dir . '/external/mpdf/mpdf/src/Gif/Lzw.php',
	'Mpdf\\Gradient'                                       => $base_dir . '/external/mpdf/mpdf/src/Gradient.php',
	'Mpdf\\HTMLParserMode'                                 => $base_dir . '/external/mpdf/mpdf/src/HTMLParserMode.php',
	'Mpdf\\Hyphenator'                                     => $base_dir . '/external/mpdf/mpdf/src/Hyphenator.php',
	'Mpdf\\Image\\Bmp'                                     => $base_dir . '/external/mpdf/mpdf/src/Image/Bmp.php',
	'Mpdf\\Image\\ImageProcessor'                          => $base_dir . '/external/mpdf/mpdf/src/Image/ImageProcessor.php',
	'Mpdf\\Image\\ImageTypeGuesser'                        => $base_dir . '/external/mpdf/mpdf/src/Image/ImageTypeGuesser.php',
	'Mpdf\\Image\\Svg'                                     => $base_dir . '/external/mpdf/mpdf/src/Image/Svg.php',
	'Mpdf\\Image\\Wmf'                                     => $base_dir . '/external/mpdf/mpdf/src/Image/Wmf.php',
	'Mpdf\\Language\\LanguageToFont'                       => $base_dir . '/external/mpdf/mpdf/src/Language/LanguageToFont.php',
	'Mpdf\\Language\\LanguageToFontInterface'              => $base_dir . '/external/mpdf/mpdf/src/Language/LanguageToFontInterface.php',
	'Mpdf\\Language\\ScriptToLanguage'                     => $base_dir . '/external/mpdf/mpdf/src/Language/ScriptToLanguage.php',
	'Mpdf\\Language\\ScriptToLanguageInterface'            => $base_dir . '/external/mpdf/mpdf/src/Language/ScriptToLanguageInterface.php',
	'Mpdf\\Log\\Context'                                   => $base_dir . '/external/mpdf/mpdf/src/Log/Context.php',
	'Mpdf\\Mpdf'                                           => $base_dir . '/external/mpdf/mpdf/src/Mpdf.php',
	'Mpdf\\MpdfException'                                  => $base_dir . '/external/mpdf/mpdf/src/MpdfException.php',
	'Mpdf\\MpdfImageException'                             => $base_dir . '/external/mpdf/mpdf/src/MpdfImageException.php',
	'Mpdf\\Otl'                                            => $base_dir . '/external/mpdf/mpdf/src/Otl.php',
	'Mpdf\\OtlDump'                                        => $base_dir . '/external/mpdf/mpdf/src/OtlDump.php',
	'Mpdf\\Output\\Destination'                            => $base_dir . '/external/mpdf/mpdf/src/Output/Destination.php',
	'Mpdf\\PageFormat'                                     => $base_dir . '/external/mpdf/mpdf/src/PageFormat.php',
	'Mpdf\\Pdf\\Protection'                                => $base_dir . '/external/mpdf/mpdf/src/Pdf/Protection.php',
	'Mpdf\\Pdf\\Protection\\UniqidGenerator'               => $base_dir . '/external/mpdf/mpdf/src/Pdf/Protection/UniqidGenerator.php',
	'Mpdf\\RemoteContentFetcher'                           => $base_dir . '/external/mpdf/mpdf/src/RemoteContentFetcher.php',
	'Mpdf\\ServiceFactory'                                 => $base_dir . '/external/mpdf/mpdf/src/ServiceFactory.php',
	'Mpdf\\Shaper\\Indic'                                  => $base_dir . '/external/mpdf/mpdf/src/Shaper/Indic.php',
	'Mpdf\\Shaper\\Myanmar'                                => $base_dir . '/external/mpdf/mpdf/src/Shaper/Myanmar.php',
	'Mpdf\\Shaper\\Sea'                                    => $base_dir . '/external/mpdf/mpdf/src/Shaper/Sea.php',
	'Mpdf\\SizeConverter'                                  => $base_dir . '/external/mpdf/mpdf/src/SizeConverter.php',
	'Mpdf\\Strict'                                         => $base_dir . '/external/mpdf/mpdf/src/Strict.php',
	'Mpdf\\TTFontFile'                                     => $base_dir . '/external/mpdf/mpdf/src/TTFontFile.php',
	'Mpdf\\TTFontFileAnalysis'                             => $base_dir . '/external/mpdf/mpdf/src/TTFontFileAnalysis.php',
	'Mpdf\\TableOfContents'                                => $base_dir . '/external/mpdf/mpdf/src/TableOfContents.php',
	'Mpdf\\Tag'                                            => $base_dir . '/external/mpdf/mpdf/src/Tag.php',
	'Mpdf\\Tag\\A'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/A.php',
	'Mpdf\\Tag\\Acronym'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Acronym.php',
	'Mpdf\\Tag\\Address'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Address.php',
	'Mpdf\\Tag\\Annotation'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/Annotation.php',
	'Mpdf\\Tag\\Article'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Article.php',
	'Mpdf\\Tag\\Aside'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Aside.php',
	'Mpdf\\Tag\\B'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/B.php',
	'Mpdf\\Tag\\BarCode'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/BarCode.php',
	'Mpdf\\Tag\\Bdi'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Bdi.php',
	'Mpdf\\Tag\\Bdo'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Bdo.php',
	'Mpdf\\Tag\\Big'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Big.php',
	'Mpdf\\Tag\\BlockQuote'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/BlockQuote.php',
	'Mpdf\\Tag\\BlockTag'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/BlockTag.php',
	'Mpdf\\Tag\\Bookmark'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/Bookmark.php',
	'Mpdf\\Tag\\Br'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Br.php',
	'Mpdf\\Tag\\Caption'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Caption.php',
	'Mpdf\\Tag\\Center'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Center.php',
	'Mpdf\\Tag\\Cite'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Cite.php',
	'Mpdf\\Tag\\Code'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Code.php',
	'Mpdf\\Tag\\ColumnBreak'                               => $base_dir . '/external/mpdf/mpdf/src/Tag/ColumnBreak.php',
	'Mpdf\\Tag\\Columns'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Columns.php',
	'Mpdf\\Tag\\Dd'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Dd.php',
	'Mpdf\\Tag\\Del'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Del.php',
	'Mpdf\\Tag\\Details'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Details.php',
	'Mpdf\\Tag\\Div'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Div.php',
	'Mpdf\\Tag\\Dl'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Dl.php',
	'Mpdf\\Tag\\DotTab'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/DotTab.php',
	'Mpdf\\Tag\\Dt'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Dt.php',
	'Mpdf\\Tag\\Em'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Em.php',
	'Mpdf\\Tag\\FieldSet'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/FieldSet.php',
	'Mpdf\\Tag\\FigCaption'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/FigCaption.php',
	'Mpdf\\Tag\\Figure'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Figure.php',
	'Mpdf\\Tag\\Font'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Font.php',
	'Mpdf\\Tag\\Footer'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Footer.php',
	'Mpdf\\Tag\\Form'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Form.php',
	'Mpdf\\Tag\\FormFeed'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/FormFeed.php',
	'Mpdf\\Tag\\H1'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H1.php',
	'Mpdf\\Tag\\H2'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H2.php',
	'Mpdf\\Tag\\H3'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H3.php',
	'Mpdf\\Tag\\H4'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H4.php',
	'Mpdf\\Tag\\H5'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H5.php',
	'Mpdf\\Tag\\H6'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H6.php',
	'Mpdf\\Tag\\HGroup'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/HGroup.php',
	'Mpdf\\Tag\\Header'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Header.php',
	'Mpdf\\Tag\\Hr'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Hr.php',
	'Mpdf\\Tag\\I'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/I.php',
	'Mpdf\\Tag\\Img'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Img.php',
	'Mpdf\\Tag\\IndexEntry'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/IndexEntry.php',
	'Mpdf\\Tag\\IndexInsert'                               => $base_dir . '/external/mpdf/mpdf/src/Tag/IndexInsert.php',
	'Mpdf\\Tag\\InlineTag'                                 => $base_dir . '/external/mpdf/mpdf/src/Tag/InlineTag.php',
	'Mpdf\\Tag\\Input'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Input.php',
	'Mpdf\\Tag\\Ins'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Ins.php',
	'Mpdf\\Tag\\Kbd'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Kbd.php',
	'Mpdf\\Tag\\Legend'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Legend.php',
	'Mpdf\\Tag\\Li'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Li.php',
	'Mpdf\\Tag\\Main'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Main.php',
	'Mpdf\\Tag\\Mark'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Mark.php',
	'Mpdf\\Tag\\Meter'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Meter.php',
	'Mpdf\\Tag\\Nav'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Nav.php',
	'Mpdf\\Tag\\NewColumn'                                 => $base_dir . '/external/mpdf/mpdf/src/Tag/NewColumn.php',
	'Mpdf\\Tag\\NewPage'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/NewPage.php',
	'Mpdf\\Tag\\Ol'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Ol.php',
	'Mpdf\\Tag\\Option'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Option.php',
	'Mpdf\\Tag\\P'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/P.php',
	'Mpdf\\Tag\\PageBreak'                                 => $base_dir . '/external/mpdf/mpdf/src/Tag/PageBreak.php',
	'Mpdf\\Tag\\PageFooter'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/PageFooter.php',
	'Mpdf\\Tag\\PageHeader'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/PageHeader.php',
	'Mpdf\\Tag\\Pre'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Pre.php',
	'Mpdf\\Tag\\Progress'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/Progress.php',
	'Mpdf\\Tag\\Q'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/Q.php',
	'Mpdf\\Tag\\S'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/S.php',
	'Mpdf\\Tag\\Samp'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Samp.php',
	'Mpdf\\Tag\\Section'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Section.php',
	'Mpdf\\Tag\\Select'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Select.php',
	'Mpdf\\Tag\\SetHtmlPageFooter'                         => $base_dir . '/external/mpdf/mpdf/src/Tag/SetHtmlPageFooter.php',
	'Mpdf\\Tag\\SetHtmlPageHeader'                         => $base_dir . '/external/mpdf/mpdf/src/Tag/SetHtmlPageHeader.php',
	'Mpdf\\Tag\\SetPageFooter'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/SetPageFooter.php',
	'Mpdf\\Tag\\SetPageHeader'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/SetPageHeader.php',
	'Mpdf\\Tag\\Small'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Small.php',
	'Mpdf\\Tag\\Span'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Span.php',
	'Mpdf\\Tag\\Strike'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Strike.php',
	'Mpdf\\Tag\\Strong'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Strong.php',
	'Mpdf\\Tag\\Sub'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Sub.php',
	'Mpdf\\Tag\\SubstituteTag'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/SubstituteTag.php',
	'Mpdf\\Tag\\Summary'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Summary.php',
	'Mpdf\\Tag\\Sup'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Sup.php',
	'Mpdf\\Tag\\TBody'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/TBody.php',
	'Mpdf\\Tag\\TFoot'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/TFoot.php',
	'Mpdf\\Tag\\THead'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/THead.php',
	'Mpdf\\Tag\\Table'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Table.php',
	'Mpdf\\Tag\\Tag'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Tag.php',
	'Mpdf\\Tag\\Td'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Td.php',
	'Mpdf\\Tag\\TextArea'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/TextArea.php',
	'Mpdf\\Tag\\TextCircle'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/TextCircle.php',
	'Mpdf\\Tag\\Th'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Th.php',
	'Mpdf\\Tag\\Time'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Time.php',
	'Mpdf\\Tag\\Toc'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Toc.php',
	'Mpdf\\Tag\\TocEntry'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/TocEntry.php',
	'Mpdf\\Tag\\TocPageBreak'                              => $base_dir . '/external/mpdf/mpdf/src/Tag/TocPageBreak.php',
	'Mpdf\\Tag\\Tr'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Tr.php',
	'Mpdf\\Tag\\Tt'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Tt.php',
	'Mpdf\\Tag\\Tta'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Tta.php',
	'Mpdf\\Tag\\Tts'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Tts.php',
	'Mpdf\\Tag\\Ttz'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Ttz.php',
	'Mpdf\\Tag\\U'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/U.php',
	'Mpdf\\Tag\\Ul'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Ul.php',
	'Mpdf\\Tag\\VarTag'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/VarTag.php',
	'Mpdf\\Tag\\WatermarkImage'                            => $base_dir . '/external/mpdf/mpdf/src/Tag/WatermarkImage.php',
	'Mpdf\\Tag\\WatermarkText'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/WatermarkText.php',
	'Mpdf\\Ucdn'                                           => $base_dir . '/external/mpdf/mpdf/src/Ucdn.php',
	'Mpdf\\Utils\\Arrays'                                  => $base_dir . '/external/mpdf/mpdf/src/Utils/Arrays.php',
	'Mpdf\\Utils\\NumericString'                           => $base_dir . '/external/mpdf/mpdf/src/Utils/NumericString.php',
	'Mpdf\\Utils\\PdfDate'                                 => $base_dir . '/external/mpdf/mpdf/src/Utils/PdfDate.php',
	'Mpdf\\Utils\\UtfString'                               => $base_dir . '/external/mpdf/mpdf/src/Utils/UtfString.php',
	'Mpdf\\Writer\\BackgroundWriter'                       => $base_dir . '/external/mpdf/mpdf/src/Writer/BackgroundWriter.php',
	'Mpdf\\Writer\\BaseWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/BaseWriter.php',
	'Mpdf\\Writer\\BookmarkWriter'                         => $base_dir . '/external/mpdf/mpdf/src/Writer/BookmarkWriter.php',
	'Mpdf\\Writer\\ColorWriter'                            => $base_dir . '/external/mpdf/mpdf/src/Writer/ColorWriter.php',
	'Mpdf\\Writer\\FontWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/FontWriter.php',
	'Mpdf\\Writer\\FormWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/FormWriter.php',
	'Mpdf\\Writer\\ImageWriter'                            => $base_dir . '/external/mpdf/mpdf/src/Writer/ImageWriter.php',
	'Mpdf\\Writer\\JavaScriptWriter'                       => $base_dir . '/external/mpdf/mpdf/src/Writer/JavaScriptWriter.php',
	'Mpdf\\Writer\\MetadataWriter'                         => $base_dir . '/external/mpdf/mpdf/src/Writer/MetadataWriter.php',
	'Mpdf\\Writer\\ObjectWriter'                           => $base_dir . '/external/mpdf/mpdf/src/Writer/ObjectWriter.php',
	'Mpdf\\Writer\\OptionalContentWriter'                  => $base_dir . '/external/mpdf/mpdf/src/Writer/OptionalContentWriter.php',
	'Mpdf\\Writer\\PageWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/PageWriter.php',
	'Mpdf\\Writer\\ResourceWriter'                         => $base_dir . '/external/mpdf/mpdf/src/Writer/ResourceWriter.php',
	'Psr\\Log\\AbstractLogger'                             => $base_dir . '/external/psr/log/Psr/Log/AbstractLogger.php',
	'Psr\\Log\\InvalidArgumentException'                   => $base_dir . '/external/psr/log/Psr/Log/InvalidArgumentException.php',
	'Psr\\Log\\LogLevel'                                   => $base_dir . '/external/psr/log/Psr/Log/LogLevel.php',
	'Psr\\Log\\LoggerAwareInterface'                       => $base_dir . '/external/psr/log/Psr/Log/LoggerAwareInterface.php',
	'Psr\\Log\\LoggerAwareTrait'                           => $base_dir . '/external/psr/log/Psr/Log/LoggerAwareTrait.php',
	'Psr\\Log\\LoggerInterface'                            => $base_dir . '/external/psr/log/Psr/Log/LoggerInterface.php',
	'Psr\\Log\\LoggerTrait'                                => $base_dir . '/external/psr/log/Psr/Log/LoggerTrait.php',
	'Psr\\Log\\NullLogger'                                 => $base_dir . '/external/psr/log/Psr/Log/NullLogger.php',
	'Psr\\Log\\Test\\DummyTest'                            => $base_dir . '/external/psr/log/Psr/Log/Test/DummyTest.php',
	'Psr\\Log\\Test\\LoggerInterfaceTest'                  => $base_dir . '/external/psr/log/Psr/Log/Test/LoggerInterfaceTest.php',
	'Psr\\Log\\Test\\TestLogger'                           => $base_dir . '/external/psr/log/Psr/Log/Test/TestLogger.php',
	'TypeError'                                            => $base_dir . '/external/paragonie/random_compat/lib/error_polyfill.php',
	'setasign\\Fpdi\\FpdfTpl'                              => $base_dir . '/external/setasign/fpdi/src/FpdfTpl.php',
	'setasign\\Fpdi\\FpdfTplTrait'                         => $base_dir . '/external/setasign/fpdi/src/FpdfTplTrait.php',
	'setasign\\Fpdi\\Fpdi'                                 => $base_dir . '/external/setasign/fpdi/src/Fpdi.php',
	'setasign\\Fpdi\\FpdiException'                        => $base_dir . '/external/setasign/fpdi/src/FpdiException.php',
	'setasign\\Fpdi\\FpdiTrait'                            => $base_dir . '/external/setasign/fpdi/src/FpdiTrait.php',
	'setasign\\Fpdi\\PdfParser\\CrossReference\\AbstractReader' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/AbstractReader.php',
	'setasign\\Fpdi\\PdfParser\\CrossReference\\CrossReference' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/CrossReference.php',
	'setasign\\Fpdi\\PdfParser\\CrossReference\\CrossReferenceException' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/CrossReferenceException.php',
	'setasign\\Fpdi\\PdfParser\\CrossReference\\FixedReader' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/FixedReader.php',
	'setasign\\Fpdi\\PdfParser\\CrossReference\\LineReader' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/LineReader.php',
	'setasign\\Fpdi\\PdfParser\\CrossReference\\ReaderInterface' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/ReaderInterface.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\Ascii85'           => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Ascii85.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\Ascii85Exception'  => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Ascii85Exception.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\AsciiHex'          => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/AsciiHex.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\FilterException'   => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/FilterException.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\FilterInterface'   => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/FilterInterface.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\Flate'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Flate.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\FlateException'    => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/FlateException.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\Lzw'               => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Lzw.php',
	'setasign\\Fpdi\\PdfParser\\Filter\\LzwException'      => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/LzwException.php',
	'setasign\\Fpdi\\PdfParser\\PdfParser'                 => $base_dir . '/external/setasign/fpdi/src/PdfParser/PdfParser.php',
	'setasign\\Fpdi\\PdfParser\\PdfParserException'        => $base_dir . '/external/setasign/fpdi/src/PdfParser/PdfParserException.php',
	'setasign\\Fpdi\\PdfParser\\StreamReader'              => $base_dir . '/external/setasign/fpdi/src/PdfParser/StreamReader.php',
	'setasign\\Fpdi\\PdfParser\\Tokenizer'                 => $base_dir . '/external/setasign/fpdi/src/PdfParser/Tokenizer.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfArray'            => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfArray.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfBoolean'          => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfBoolean.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfDictionary'       => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfDictionary.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfHexString'        => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfHexString.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfIndirectObject'   => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfIndirectObject.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfIndirectObjectReference' => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfIndirectObjectReference.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfName'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfName.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfNull'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfNull.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfNumeric'          => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfNumeric.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfStream'           => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfStream.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfString'           => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfString.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfToken'            => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfToken.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfType'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfType.php',
	'setasign\\Fpdi\\PdfParser\\Type\\PdfTypeException'    => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfTypeException.php',
	'setasign\\Fpdi\\PdfReader\\DataStructure\\Rectangle'  => $base_dir . '/external/setasign/fpdi/src/PdfReader/DataStructure/Rectangle.php',
	'setasign\\Fpdi\\PdfReader\\Page'                      => $base_dir . '/external/setasign/fpdi/src/PdfReader/Page.php',
	'setasign\\Fpdi\\PdfReader\\PageBoundaries'            => $base_dir . '/external/setasign/fpdi/src/PdfReader/PageBoundaries.php',
	'setasign\\Fpdi\\PdfReader\\PdfReader'                 => $base_dir . '/external/setasign/fpdi/src/PdfReader/PdfReader.php',
	'setasign\\Fpdi\\PdfReader\\PdfReaderException'        => $base_dir . '/external/setasign/fpdi/src/PdfReader/PdfReaderException.php',
	'setasign\\Fpdi\\TcpdfFpdi'                            => $base_dir . '/external/setasign/fpdi/src/TcpdfFpdi.php',
	'setasign\\Fpdi\\Tcpdf\\Fpdi'                          => $base_dir . '/external/setasign/fpdi/src/Tcpdf/Fpdi.php',
	'setasign\\Fpdi\\Tfpdf\\FpdfTpl'                       => $base_dir . '/external/setasign/fpdi/src/Tfpdf/FpdfTpl.php',
	'setasign\\Fpdi\\Tfpdf\\Fpdi'                          => $base_dir . '/external/setasign/fpdi/src/Tfpdf/Fpdi.php',
	'simplehtmldom\\Debug'                                 => $base_dir . '/external/simplehtmldom/simplehtmldom/Debug.php',
	'simplehtmldom\\HtmlDocument'                          => $base_dir . '/external/simplehtmldom/simplehtmldom/HtmlDocument.php',
	'simplehtmldom\\HtmlNode'                              => $base_dir . '/external/simplehtmldom/simplehtmldom/HtmlNode.php',
	'simplehtmldom\\HtmlWeb'                               => $base_dir . '/external/simplehtmldom/simplehtmldom/HtmlWeb.php',
);


spl_autoload_register(
	function ( $class ) use ( $class_map ) {
		if ( isset( $class_map[ $class ] ) ) {
			require_once $class_map[ $class ];
		}
	}
);
